/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// --------------
// IOrderedCursor
// --------------

// public members

template <class Element>
inline IBoolean
IOrderedCursor <Element>::
setToLast ()
{ return ImplOf (*this).SetToLast ();
}


template <class Element>
inline IBoolean
IOrderedCursor <Element>::
setToPrevious ()
{ return ImplOf (*this).SetToPrevious ();
}

// protected members

template <class Element>
inline
IOrderedCursor <Element>::
IOrderedCursor (Implementation* impl)
: IElementCursor <Element> (impl)
{
}

// -------------------
// IAOrderedCollection
// -------------------

// public members

template <class Element>
inline
IAOrderedCollection <Element>::
IAOrderedCollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IAOrderedCollection <Element>::
~IAOrderedCollection ()
{
}

template <class Element>
inline Element const&
IAOrderedCollection <Element>::
elementAtPosition (IPosition position) const
{ return *(Element const*) ImplOf (*this).
    ElementAtPosition (position);
}

template <class Element>
inline Element const&
IAOrderedCollection <Element>::
firstElement () const
{ return *(Element const*) ImplOf (*this).First ();
}

template <class Element>
inline Element const&
IAOrderedCollection <Element>::
first () const
{ return *(Element const*) ImplOf (*this).First ();
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
isFirst (ICursor const& cursor) const
{ return ImplOf (*this).IsFirstAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
isFirstAt (ICursor const& cursor) const
{ return ImplOf (*this).IsFirstAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
isLast (ICursor const& cursor) const
{ return ImplOf (*this).IsLastAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
isLastAt (ICursor const& cursor) const
{ return ImplOf (*this).IsLastAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IAOrderedCollection <Element>::
lastElement () const
{ return *(Element const*) ImplOf (*this).Last ();
}

template <class Element>
inline Element const&
IAOrderedCollection <Element>::
last () const
{ return *(Element const*) ImplOf (*this).Last ();
}

template <class Element>
inline IPosition
IAOrderedCollection <Element>::
position (ICursor const& cursor) const
{ return ImplOf (*this).PositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline IPosition
IAOrderedCollection <Element>::
positionAt (ICursor const& cursor) const
{ return ImplOf (*this).PositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline void
IAOrderedCollection <Element>::
removeAtPosition (IPosition position)
{ ImplOf (*this).RemoveAtPosition (position);
}

template <class Element>
inline void
IAOrderedCollection <Element>::
removeFirst ()
{ ImplOf (*this).RemoveFirst ();
}

template <class Element>
inline void
IAOrderedCollection <Element>::
removeLast ()
{ ImplOf (*this).RemoveLast ();
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
setToLast (ICursor& cursor) const
{ return ImplOf (*this).SetToLast (CrsrImplOf (cursor));
}

template <class Element>
inline void
IAOrderedCollection <Element>::
setToPosition (IPosition position, ICursor& cursor) const
{ ImplOf (*this).SetToPosition (position, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAOrderedCollection <Element>::
setToPrevious (ICursor& cursor) const
{ return ImplOf (*this).SetToPrevious (CrsrImplOf (cursor));
}

// protected members

template <class Element>
inline
IAOrderedCollection <Element>::
IAOrderedCollection ()
{
}

template <class Element>
inline
IAOrderedCollection <Element>::
IAOrderedCollection (IAOrderedCollection <Element> const&)
{
}

// private members

template <class Element>
inline IAOrderedCollection <Element>::Implementation&
IAOrderedCollection <Element>::
ImplOf (IAOrderedCollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
