/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAPPL_H
#define _IAPPL_H

#include <iglobals.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IApplicator {
public:

  virtual
  IBoolean applyTo          (Element&) = 0;

protected:

private:


};

template <class Element>
class IConstantApplicator {
public:

  virtual
  IBoolean applyTo          (Element const&) = 0;

protected:

private:


};

class IInternalApplicator {
public:

  virtual
  IBoolean applyTo          (void*)
           { return true;
           }

protected:

private:


};

inline IBoolean
__applFunc (void* element, void* applicator)
{
  return ((IInternalApplicator*)applicator)->applyTo (element);
}

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
