/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAQU_H
#define _IAQU_H

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IAQueue :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:

           IAQueue
                            (INotifier&);

          ~IAQueue
                            ();

  void     addAsLast        (Element const&);

  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IAQueue <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     dequeue          ();

  void     dequeue          (Element&);

  void     enqueue          (Element const&);

  void     enqueue          (Element const&, ICursor&);

  void     removeFirst      ();

protected:

           IAQueue
                            ();

           IAQueue
                            (IAQueue <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAQueue <Element> const&);


};

#include <iaqu.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
