/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAQueue
// ---

template <class Element>
inline
IAQueue <Element>::
IAQueue (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IAQueue <Element>::
~IAQueue ()
{
}

template <class Element>
inline void
IAQueue <Element>::
addAsLast (Element const& element)
{ ImplOf (*this).AddAsLast (&element);
}

template <class Element>
inline void
IAQueue <Element>::
addAsLast (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline long
IAQueue <Element>::
compare (IAQueue <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline void
IAQueue <Element>::
dequeue ()
{ ImplOf (*this).RemoveFirst ();
}

template <class Element>
inline void
IAQueue <Element>::
dequeue (Element& element)
{ element = *(Element*) ImplOf (*this).First ();
  ImplOf (*this).RemoveFirst ();
}

template <class Element>
inline void
IAQueue <Element>::
enqueue (Element const& element)
{ ImplOf (*this).Add (&element);
}

template <class Element>
inline void
IAQueue <Element>::
enqueue (Element const& element, ICursor& cursor)
{ ImplOf (*this).Add (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IAQueue <Element>::
removeFirst ()
{ ImplOf (*this).RemoveFirst ();
}

// protected members

template <class Element>
inline
IAQueue <Element>::
IAQueue ()
{
}

template <class Element>
inline
IAQueue <Element>::
IAQueue (IAQueue <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IAQueue <Element>::Implementation&
IAQueue <Element>::
ImplOf (IAQueue <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
