/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IARSTRCT_H
#define _IARSTRCT_H

#include <ibcllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IARestrictedAccessCollection : protected IACollectionBase {

  typedef  IACollectionImpl Implementation;

public:

           IARestrictedAccessCollection
                            (INotifier&);

  virtual ~IARestrictedAccessCollection
                            ();

  IBoolean add              (Element const&);

  IBoolean add              (Element const&, ICursor&);

  void     addAllFrom       (IARestrictedAccessCollection
                              <Element> const&);

  IBoolean allElementsDo    (IBoolean (*applicatorFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0) const;

  IBoolean allElementsDo    (IConstantApplicator <Element>&) const;

  Element const&
           any              () const;

  void     copy             (IARestrictedAccessCollection
                              <Element> const&);

  INotifier&
           disableNotification
                            ();

  Element const&
           elementAt        (ICursor const&) const;

  Element const&
           elementAtPosition
                            (IPosition) const;

  INotifier&
           enableNotification
                            (IBoolean = true);

  Element const&
           first            () const;

  IBoolean isBounded        () const;

  IBoolean isConsistent     () const;

  IBoolean isEmpty          () const;

  IBoolean isEnabledForNotification
                            () const;

  IBoolean isFirstAt        (ICursor const&) const;

  IBoolean isFull           () const;

  IBoolean isLastAt         (ICursor const&) const;

  Element const&
           last             () const;

  INumber  maxNumberOfElements
                            () const;

  ICursor* newCursor        () const;

  INotifier&
           notifier
                            ();

  INotifier const&
           notifier
                            () const;

  INotifier&
           notifyObservers  (INotificationEvent const&);

  INumber  numberOfElements () const;

  IPosition
           positionAt       (ICursor const&) const;

  INumber  removeAll        ();

  IBoolean setToFirst       (ICursor&) const;

  IBoolean setToLast        (ICursor&) const;

  IBoolean setToNext        (ICursor&) const;

  void     setToPosition    (IPosition, ICursor&) const;

  IBoolean setToPrevious    (ICursor&) const;

           operator INotifier&
                            () const;

  // for backward compatibility
  Element const&
           anyElement       () const;

  Element const&
           firstElement     () const;

  IBoolean isFirst          (ICursor const&) const;

  IBoolean isLast           (ICursor const&) const;

  Element const&
           lastElement      () const;

  IPosition
           position         (ICursor const&) const;

protected:

           IARestrictedAccessCollection
                            ();

           IARestrictedAccessCollection
                            (IARestrictedAccessCollection
                              <Element> const&);

  static
  Implementation&
           ImplOf           (IARestrictedAccessCollection
                              <Element> const&);

private:


};

#pragma SOMAsDefault (pop)

#include <iarstrct.inl>

#pragma info (restore)
#pragma pack ()

#endif
