/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ----------------------------
// IARestrictedAccessCollection
// ----------------------------

// public members
template <class Element>
inline
IARestrictedAccessCollection <Element>::
IARestrictedAccessCollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IARestrictedAccessCollection <Element>::
~IARestrictedAccessCollection ()
{
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
add (Element const& element)
{ return ImplOf (*this).Add (&element);
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
add (Element const& element, ICursor& cursor)
{ return ImplOf (*this).Add (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IARestrictedAccessCollection <Element>::
addAllFrom (IARestrictedAccessCollection <Element> const& collection)
{ ImplOf (*this).AddAllFrom (ImplOf (collection));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
allElementsDo (IBoolean (*applFunc) (Element const&, void*),
               void* addArg) const
{ return ImplOf (*this).AllElementsDo ((IApplFunc)applFunc, addArg);
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
allElementsDo (IConstantApplicator <Element>& applicator) const
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)__applFunc, &applicator);
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
anyElement () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
any () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline void
IARestrictedAccessCollection <Element>::
copy (IARestrictedAccessCollection <Element> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
}

template <class Element>
inline INotifier&
IARestrictedAccessCollection <Element>::
disableNotification ()
{ return ImplOf (*this).DisableNotification ();
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
elementAt (ICursor const& cursor) const
{ return *(Element const*) ImplOf (*this).
    ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
elementAtPosition (IPosition position) const
{ return *(Element const*) ImplOf (*this).ElementAtPosition (position);
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
firstElement () const
{ return *(Element const*) ImplOf (*this).First ();
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
first () const
{ return *(Element const*) ImplOf (*this).First ();
}

template <class Element>
inline INotifier&
IARestrictedAccessCollection <Element>::
enableNotification (IBoolean enable)
{ return ImplOf (*this).EnableNotification (enable);
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isBounded () const
{ return ImplOf (*this).IsBounded ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isConsistent () const
{ return ImplOf (*this).IsConsistent ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isEmpty () const
{ return ImplOf (*this).IsEmpty ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isFirst (ICursor const& cursor) const
{ return ImplOf (*this).IsFirstAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isFirstAt (ICursor const& cursor) const
{ return ImplOf (*this).IsFirstAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isEnabledForNotification () const
{ return ImplOf (*this).IsEnabledForNotification ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isFull () const
{ return ImplOf (*this).IsFull ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isLast (ICursor const& cursor) const
{ return ImplOf (*this).IsLastAt (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
isLastAt (ICursor const& cursor) const
{ return ImplOf (*this).IsLastAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
lastElement () const
{ return *(Element const*) ImplOf (*this).Last ();
}

template <class Element>
inline Element const&
IARestrictedAccessCollection <Element>::
last () const
{ return *(Element const*) ImplOf (*this).Last ();
}

template <class Element>
inline INumber
IARestrictedAccessCollection <Element>::
maxNumberOfElements () const
{ return ImplOf (*this).MaxNumberOfElements ();
}

template <class Element>
inline ICursor*
IARestrictedAccessCollection <Element>::
newCursor () const
{ return InterfaceFor (ImplOf (*this).CreateCursor ());
}

template <class Element>
inline INotifier&
IARestrictedAccessCollection <Element>::
notifier ()
{ return ImplOf (*this);
}

template <class Element>
inline INotifier const&
IARestrictedAccessCollection <Element>::
notifier () const
{ return ImplOf (*this);
}

template <class Element>
inline INotifier&
IARestrictedAccessCollection <Element>::
notifyObservers (INotificationEvent const& event)
{ return ImplOf (*this).notifyObservers (event);
}

template <class Element>
inline INumber
IARestrictedAccessCollection <Element>::
numberOfElements () const
{ return ImplOf (*this).NumberOfElements ();
}

template <class Element>
inline IPosition
IARestrictedAccessCollection <Element>::
position (ICursor const& cursor) const
{ return ImplOf (*this).PositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline IPosition
IARestrictedAccessCollection <Element>::
positionAt (ICursor const& cursor) const
{ return ImplOf (*this).PositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IARestrictedAccessCollection <Element>::
removeAll ()
{ return ImplOf (*this).RemoveAll ();
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
setToFirst (ICursor& cursor) const
{ return ImplOf (*this).SetToFirst (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
setToLast (ICursor& cursor) const
{ return ImplOf (*this).SetToLast (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
setToNext (ICursor& cursor) const
{ return ImplOf (*this).SetToNext (CrsrImplOf (cursor));
}

template <class Element>
inline void
IARestrictedAccessCollection <Element>::
setToPosition (IPosition position, ICursor& cursor) const
{ ImplOf (*this).SetToPosition (position, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IARestrictedAccessCollection <Element>::
setToPrevious (ICursor& cursor) const
{ return ImplOf (*this).SetToPrevious (CrsrImplOf (cursor));
}

template <class Element>
inline
IARestrictedAccessCollection <Element>::
operator INotifier& () const
{ return ImplOf (*this);
}

// protected members

template <class Element>
inline
IARestrictedAccessCollection <Element>::
IARestrictedAccessCollection ()
: IACollectionBase ()
{
}

template <class Element>
inline
IARestrictedAccessCollection <Element>::
IARestrictedAccessCollection
  (IARestrictedAccessCollection <Element> const& collection)
: IACollectionBase (collection)
{
}

template <class Element>
inline IARestrictedAccessCollection <Element>::Implementation&
IARestrictedAccessCollection <Element>::
ImplOf (IARestrictedAccessCollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
