/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASortedBag
// ---

template <class Element>
inline
IASortedBag <Element>::
IASortedBag (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IASortedBag <Element>::
~IASortedBag ()
{
}

template <class Element>
inline void
IASortedBag <Element>::
addDifference (IASortedBag <Element> const& collection1,
               IASortedBag <Element> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASortedBag <Element>::
addIntersection (IASortedBag <Element> const& collection1,
                 IASortedBag <Element> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IASortedBag <Element>::
addUnion (IASortedBag <Element> const& collection1,
          IASortedBag <Element> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline long
IASortedBag <Element>::
compare (IASortedBag <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline void
IASortedBag <Element>::
differenceWith (IASortedBag <Element> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element>
inline void
IASortedBag <Element>::
intersectionWith (IASortedBag <Element> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element>
inline INumber
IASortedBag <Element>::
numberOfDifferentElements () const
{ return ImplOf (*this).NumberOfDifferentElements ();
}

template <class Element>
inline IBoolean
IASortedBag <Element>::
setToNextDifferentElement (ICursor& cursor) const
{ return ImplOf (*this).SetToNextDifferentElement (CrsrImplOf (cursor));
}

template <class Element>
inline void
IASortedBag <Element>::
unionWith (IASortedBag <Element> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASortedBag <Element>::
operator== (IASortedBag <Element> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element>
inline IBoolean
IASortedBag <Element>::
operator!= (IASortedBag <Element> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element>
inline
IASortedBag <Element>::
IASortedBag ()
{
}

template <class Element>
inline
IASortedBag <Element>::
IASortedBag (IASortedBag <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IASortedBag <Element>::Implementation&
IASortedBag <Element>::
ImplOf (IASortedBag <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
