/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASET_H
#define _IASET_H

#include <iaequal.h>
#include <iiaset.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IASet :
  public IAEqualityCollection <Element> {

  typedef  IAEqualityCollection <Element> Inherited;

  typedef  IASetImpl Implementation;

public:

           IASet
                            (INotifier&);

          ~IASet
                            ();

  void     addDifference    (IASet <Element> const&,
                             IASet <Element> const&); 

  void     addIntersection  (IASet <Element> const&,
                             IASet <Element> const&);

  void     addUnion         (IASet <Element> const&,
                             IASet <Element> const&);

  void     differenceWith   (IASet <Element> const&);

  void     intersectionWith (IASet <Element> const&);

  void     unionWith        (IASet <Element> const&);

  IBoolean operator==       (IASet
                              <Element> const&) const;

  IBoolean operator!=       (IASet
                              <Element> const&) const;

protected:

           IASet
                            ();

           IASet
                            (IASet <Element> const&);

  IBoolean locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASet <Element> const&);


};

#include <iaset.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
