/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASM_H
#define _IASM_H

#include <iaeqksrt.h>
#include <iiasm.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IASortedMap :
  public IAEqualityKeySortedCollection <Element, Key> {

  typedef  IAEqualityKeySortedCollection <Element, Key> Inherited;

  typedef  IASortedMapImpl Implementation;

public:

           IASortedMap
                            (INotifier&);

          ~IASortedMap
                            ();

  void     addDifference    (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&); 

  void     addIntersection  (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&);

  void     addUnion         (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&);

  long     compare          (IASortedMap <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     differenceWith   (IASortedMap <Element, Key> const&);

  void     intersectionWith (IASortedMap <Element, Key> const&);

  void     unionWith        (IASortedMap <Element, Key> const&);

  IBoolean operator==       (IASortedMap
                              <Element, Key> const&) const;

  IBoolean operator!=       (IASortedMap
                              <Element, Key> const&) const;

protected:

           IASortedMap
                            ();

           IASortedMap
                            (IASortedMap <Element, Key> const&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

  INumber  removeAllElementsWithKey
                            (Key const&);

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IASortedMap <Element, Key> const&);


};

#include <iasm.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
