/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASQNTL_H
#define _IASQNTL_H

#include <iaorder.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template  <class Element>
class IASequentialCollection : public IAOrderedCollection <Element> {

  typedef IACollectionImpl Implementation;

public:

           IASequentialCollection
                            (INotifier&);

          ~IASequentialCollection
                            ();

  void     addAsFirst       (Element const&);

  void     addAsFirst       (Element const&, ICursor&);

  void     addAsLast        (Element const&);

  void     addAsLast        (Element const&, ICursor&);

  void     addAsNext        (Element const&, ICursor&);

  void     addAsPrevious    (Element const&, ICursor&);

  void     addAtPosition    (IPosition, Element const&);

  void     addAtPosition    (IPosition, Element const&, ICursor&);

  Element& any              ();

  Element const&
           any              () const;

  Element& elementAtPosition
                            (IPosition);

  Element const&
           elementAtPosition
                            (IPosition) const;

  Element& first            ();

  Element const&
           first            () const;

  Element& last             ();

  Element const&
           last             () const;

  void     reverse          ();

  void     sort             (long (*comparisonFunction)
                              (Element const&, Element const&));

protected:

           IASequentialCollection
                            ();

           IASequentialCollection
                            (IASequentialCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASequentialCollection <Element> const&);


};

#pragma SOMAsDefault (pop)

#include <iasqntl.inl>

#pragma info (restore)
#pragma pack ()

#endif
