/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ----------------------
// IASequentialCollection
// ----------------------

// public members

template <class Element>
inline
IASequentialCollection <Element>::
IASequentialCollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IASequentialCollection <Element>::
~IASequentialCollection ()
{
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsFirst (Element const& element)
{ ImplOf (*this).AddAsFirst (&element);
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsFirst (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsFirst (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsLast (Element const& element)
{ ImplOf (*this).AddAsLast (&element);
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsLast (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsNext (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsNext (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAsPrevious (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsPrevious (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAtPosition (IPosition position, Element const& element)
{ ImplOf (*this).AddAtPosition (position, &element);
}

template <class Element>
inline void
IASequentialCollection <Element>::
addAtPosition (IPosition position,
               Element const& element, ICursor& cursor)
{ ImplOf (*this).
    AddAtPosition (position, &element, CrsrImplOf (cursor));
}

template <class Element>
inline Element&
IASequentialCollection <Element>::
any ()
{ return *(Element*) ImplOf (*this).Any ();
}

template <class Element>
inline Element const&
IASequentialCollection <Element>::
any () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline Element&
IASequentialCollection <Element>::
elementAtPosition (IPosition position)
{ return *(Element*) ImplOf (*this).ElementAtPosition (position);
}

template <class Element>
inline Element const&
IASequentialCollection <Element>::
elementAtPosition (IPosition position) const
{ return *(Element const*) ImplOf (*this).ElementAtPosition (position);
}

template <class Element>
inline Element&
IASequentialCollection <Element>::
first ()
{ return *(Element*) ImplOf (*this).First ();
}

template <class Element>
inline Element const&
IASequentialCollection <Element>::
first () const
{ return *(Element const*) ImplOf (*this).First ();
}

template <class Element>
inline Element&
IASequentialCollection <Element>::
last ()
{ return *(Element*) ImplOf (*this).Last ();
}

template <class Element>
inline Element const&
IASequentialCollection <Element>::
last () const
{ return *(Element const*) ImplOf (*this).Last ();
}

template <class Element>
inline void
IASequentialCollection <Element>::
reverse ()
{ ImplOf (*this).Reverse ();
}

template <class Element>
inline void
IASequentialCollection <Element>::
sort (long (*compFunc) (Element const&, Element const&))
{ ImplOf (*this).Sort ((ICompFunc)compFunc, 0);
}

// protected members

template <class Element>
inline
IASequentialCollection <Element>::
IASequentialCollection ()
{
}

template <class Element>
inline
IASequentialCollection <Element>::
IASequentialCollection (IASequentialCollection <Element> const&)
{
}

// private members

template <class Element>
inline IASequentialCollection <Element>::Implementation&
IASequentialCollection <Element>::
ImplOf (IASequentialCollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
