/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IASortedRelation
// ---

template <class Element, class Key>
inline
IASortedRelation <Element, Key>::
IASortedRelation (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IASortedRelation <Element, Key>::
~IASortedRelation ()
{
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
addDifference (IASortedRelation <Element, Key> const& collection1,
               IASortedRelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
addIntersection (IASortedRelation <Element, Key> const& collection1,
                 IASortedRelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
addUnion (IASortedRelation <Element, Key> const& collection1,
          IASortedRelation <Element, Key> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline long
IASortedRelation <Element, Key>::
compare (IASortedRelation <Element, Key> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
differenceWith (IASortedRelation <Element, Key> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
intersectionWith (IASortedRelation <Element, Key> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element, class Key>
inline void
IASortedRelation <Element, Key>::
unionWith (IASortedRelation <Element, Key> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IASortedRelation <Element, Key>::
operator== (IASortedRelation <Element, Key> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IASortedRelation <Element, Key>::
operator!= (IASortedRelation <Element, Key> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element, class Key>
inline
IASortedRelation <Element, Key>::
IASortedRelation ()
{
}

template <class Element, class Key>
inline
IASortedRelation <Element, Key>::
IASortedRelation (IASortedRelation <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline INumber
IASortedRelation <Element, Key>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element, class Key>
inline INumber
IASortedRelation <Element, Key>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

// private members

template <class Element, class Key>
inline IASortedRelation <Element, Key>::Implementation&
IASortedRelation <Element, Key>::
ImplOf (IASortedRelation <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
