/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASS_H
#define _IASS_H

#include <iaeqsrt.h>
#include <iiass.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IASortedSet :
  public IAEqualitySortedCollection <Element> {

  typedef  IAEqualitySortedCollection <Element> Inherited;

  typedef  IASortedSetImpl Implementation;

public:

           IASortedSet
                            (INotifier&);

          ~IASortedSet
                            ();

  void     addDifference    (IASortedSet <Element> const&,
                             IASortedSet <Element> const&); 

  void     addIntersection  (IASortedSet <Element> const&,
                             IASortedSet <Element> const&);

  void     addUnion         (IASortedSet <Element> const&,
                             IASortedSet <Element> const&);

  long     compare          (IASortedSet <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     differenceWith   (IASortedSet <Element> const&);

  void     intersectionWith (IASortedSet <Element> const&);

  void     unionWith        (IASortedSet <Element> const&);

  IBoolean operator==       (IASortedSet
                              <Element> const&) const;

  IBoolean operator!=       (IASortedSet
                              <Element> const&) const;

protected:

           IASortedSet
                            ();

           IASortedSet
                            (IASortedSet <Element> const&);

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASortedSet <Element> const&);


};

#include <iass.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
