/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IASTK_H
#define _IASTK_H

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IAStack :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:

           IAStack
                            (INotifier&);

          ~IAStack
                            ();

  void     addAsLast        (Element const&);

  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IAStack <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     pop              ();

  void     pop              (Element&);

  void     push             (Element const&);

  void     push             (Element const&, ICursor&);

  void     removeLast       ();

  Element const&
           top              () const;

protected:

           IAStack
                            ();

           IAStack
                            (IAStack <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAStack <Element> const&);


};

#include <iastk.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
