/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IATREE_H
#define _IATREE_H

#include <ibtree.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IElementTreeCursor : public ITreeCursor {

  typedef  ITreeCursorImpl Implementation;

public:

  Element const&
           element          () const;

protected:

           IElementTreeCursor
                            (Implementation*);


};

template <class Element>
class IATree : protected IATreeBase {

  typedef  IATreeImpl Implementation;

public:

          ~IATree           ();

  void     addAsChild       (ITreeCursor const&,
                             IPosition, Element const&);

  void     addAsRoot        (Element const&);

  IBoolean allElementsDo    (IBoolean (*applicatorFunction)
                              (Element&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0);

  IBoolean allElementsDo    (IBoolean (*applicatorFunction)
                              (Element const&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0) const;

  IBoolean allElementsDo    (IApplicator <Element>&,
                             ITreeIterationOrder);

  IBoolean allElementsDo    (IConstantApplicator <Element>&,
                             ITreeIterationOrder) const;

  IBoolean allSubtreeElementsDo
                            (ITreeCursor const&,
                             IBoolean (*applicatorFunction)
                              (Element&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0);

  IBoolean allSubtreeElementsDo
                            (ITreeCursor const&,
                             IBoolean (*applicatorFunction)
                              (Element const&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0) const;

  IBoolean allSubtreeElementsDo
                            (ITreeCursor const&,
                             IApplicator <Element>&,
                             ITreeIterationOrder);

  IBoolean allSubtreeElementsDo
                            (ITreeCursor const&,
                             IConstantApplicator <Element>&,
                             ITreeIterationOrder) const;

  IPosition
           childPositionAt  (ITreeCursor const&) const;

  Element& elementAt        (ITreeCursor const&);

  Element const&
           elementAt        (ITreeCursor const&) const;

  IBoolean isConsistent     () const;

  IBoolean isEmpty          () const;

  IBoolean isLeaf           (ITreeCursor const&) const;

  IBoolean isRoot           (ITreeCursor const&) const;

  ITreeCursor*
           newCursor        () const;

  INumber  numberOfElements () const;

  INumber  numberOfLeaves   () const;

  INumber  numberOfSubtreeElements
                            (ITreeCursor const&) const;

  INumber  numberOfSubtreeLeaves
                            (ITreeCursor const&) const;

  INumber  removeAll        ();

  INumber  removeSubtree    (ITreeCursor&);

  void     replaceAt        (ITreeCursor const&, Element const&);

  IBoolean setToChild       (IPosition, ITreeCursor&) const;

  IBoolean setToFirst       (ITreeCursor&, ITreeIterationOrder) const;

  IBoolean setToFirstExistingChild
                            (ITreeCursor&) const;

  IBoolean setToLast        (ITreeCursor&, ITreeIterationOrder) const;

  IBoolean setToLastExistingChild
                            (ITreeCursor&) const;

  IBoolean setToNext        (ITreeCursor&, ITreeIterationOrder) const;

  IBoolean setToNextExistingChild
                            (ITreeCursor&) const;

  IBoolean setToParent      (ITreeCursor&) const;

  IBoolean setToPrevious    (ITreeCursor&, ITreeIterationOrder) const;

  IBoolean setToPreviousExistingChild
                            (ITreeCursor&) const;

  IBoolean setToRoot        (ITreeCursor&) const;

  // for backward compatibility
  IPosition
           position         (ITreeCursor const&) const;

protected:

           IATree           ();

           IATree           (IATree <Element> const&);

  static
  Implementation&
           ImplOf           (IATree <Element> const&);

private:


};

#pragma SOMAsDefault (pop)

#include <iatree.inl>

#pragma info (restore)
#pragma pack ()

#endif
