/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagCursor <Element, ElementOps>::
IGBagCursor
  (IGBag
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagCursor <Element, ElementOps>&
IGBagCursor <Element, ElementOps>::
operator=
  (IGBagCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagCursor <Element, ElementOps>::
IGBagCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBag
// ---

// public members

template <class Element, class ElementOps>
inline
IGBag <Element, ElementOps>::
IGBag (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBag <Element, ElementOps>::
IGBag
  (IGBag
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBag <Element, ElementOps>&
IGBag <Element, ElementOps>::
operator= (IGBag
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBag <Element, ElementOps>::
IGBag (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBag
 <Element, ElementOps>::Implementation&
IGBag <Element, ElementOps>::
ImplOf (IGBag
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBag
// ---

// public members

template <class Element>
inline
IBag <Element>::
IBag (INumber numberOfElements)
: IGBag
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBag <Element>::
IBag (PureImplementation& impl)
: IGBag
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGBag
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBag <Element, ElementOps>::
IVGBag (INumber numberOfElements)
: IGBag
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBag <Element, ElementOps>::
IVGBag (PureImplementation& impl)
: IGBag
    <Element, ElementOps> (impl)
{
}

// ---
// IVBag
// ---

// public members

template <class Element>
inline
IVBag <Element>::
IVBag (INumber numberOfElements)
: IVGBag
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBag <Element>::
IVBag (PureImplementation& impl)
: IVGBag
   <Element, ICOps <Element> > (impl)
{
}
