/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGAVL_H
#define _IBAGAVL_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibaglst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsAvlTree;

template <class Element, class ElementOps>
class IGBagAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsAvlTreeCursor
                            (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGBagAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGBagAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsAvlTree :
  public IABag <Element> {
protected:

  typedef  IGBagAsAvlTree <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef  IGBagAsAvlTreeCursor
            <Element, ElementOps> Cursor;


           IGBagAsAvlTree
                            (INumber = 100);

           IGBagAsAvlTree
                            (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGBagAsAvlTree <Element, ElementOps>&
           operator=        (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsAvlTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsAvlTree :
  public IGBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBagAsAvlTree <Element> Self;

#define IBagAsAvlTreeTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsAvlTree
                            (INumber = 100);


protected:

           IBagAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsAvlTree :
  public IGBagAsAvlTree
          <Element, ElementOps > {

  typedef  IVGBagAsAvlTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsAvlTreeTypedef (Element, ElementOps);

public:

           IVGBagAsAvlTree
                            (INumber = 100);


protected:

           IVGBagAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsAvlTree :
  public IVGBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBagAsAvlTree <Element> Self;

#define IVBagAsAvlTreeTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsAvlTree
                            (INumber = 100);


protected:

           IVBagAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibagavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
