/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagAsAvlTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsAvlTreeCursor <Element, ElementOps>::
IGBagAsAvlTreeCursor
  (IGBagAsAvlTree
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagAsAvlTreeCursor <Element, ElementOps>&
IGBagAsAvlTreeCursor <Element, ElementOps>::
operator=
  (IGBagAsAvlTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsAvlTreeCursor <Element, ElementOps>::
IGBagAsAvlTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBagAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsAvlTree <Element, ElementOps>::
IGBagAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBagAsAvlTree <Element, ElementOps>::
IGBagAsAvlTree
  (IGBagAsAvlTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBagAsAvlTree <Element, ElementOps>&
IGBagAsAvlTree <Element, ElementOps>::
operator= (IGBagAsAvlTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsAvlTree <Element, ElementOps>::
IGBagAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBagAsAvlTree
 <Element, ElementOps>::Implementation&
IGBagAsAvlTree <Element, ElementOps>::
ImplOf (IGBagAsAvlTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBagAsAvlTree
// ---

// public members

template <class Element>
inline
IBagAsAvlTree <Element>::
IBagAsAvlTree (INumber numberOfElements)
: IGBagAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBagAsAvlTree <Element>::
IBagAsAvlTree (PureImplementation& impl)
: IGBagAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGBagAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBagAsAvlTree <Element, ElementOps>::
IVGBagAsAvlTree (INumber numberOfElements)
: IGBagAsAvlTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBagAsAvlTree <Element, ElementOps>::
IVGBagAsAvlTree (PureImplementation& impl)
: IGBagAsAvlTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVBagAsAvlTree
// ---

// public members

template <class Element>
inline
IVBagAsAvlTree <Element>::
IVBagAsAvlTree (INumber numberOfElements)
: IVGBagAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBagAsAvlTree <Element>::
IVBagAsAvlTree (PureImplementation& impl)
: IVGBagAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}
