/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGDIL_H
#define _IBAGDIL_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibagdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsDilTable;

template <class Element, class ElementOps>
class IGBagAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsDilTableCursor
                            (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGBagAsDilTableCursor <Element, ElementOps>&
           operator=        (IGBagAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsDilTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsDilTable <Element, ElementOps> Self;

  typedef  IBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsDilTableTypedef(Element, ElementOps)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGBagAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGBagAsDilTable
                            (INumber = 100);

           IGBagAsDilTable
                            (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGBagAsDilTable <Element, ElementOps>&
           operator=        (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsDilTable :
  public IGBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBagAsDilTable <Element> Self;

#define IBagAsDilTableTypedef(Element)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsDilTable
                            (INumber = 100);


protected:

           IBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsDilTable :
  public IGBagAsDilTable
          <Element, ElementOps > {

  typedef  IVGBagAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsDilTableTypedef(Element, ElementOps)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsDilTableTypedef (Element, ElementOps);

public:

           IVGBagAsDilTable
                            (INumber = 100);


protected:

           IVGBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsDilTable :
  public IVGBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBagAsDilTable <Element> Self;

#define IVBagAsDilTableTypedef(Element)\
  typedef  IVBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsDilTable
                            (INumber = 100);


protected:

           IVBagAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibagdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
