/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGHSH_H
#define _IBAGHSH_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibaghsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsHshTable;

template <class Element, class ElementOps>
class IGBagAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsHshTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsHshTableCursor
                            (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

  IGBagAsHshTableCursor <Element, ElementOps>&
           operator=        (IGBagAsHshTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsHshTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsHshTable <Element, ElementOps> Self;

  typedef  IBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsHshTableTypedef(Element, ElementOps)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsHshTableTypedef (Element, ElementOps);

public:

  typedef  IGBagAsHshTableCursor
            <Element, ElementOps> Cursor;


           IGBagAsHshTable
                            (INumber = 100);

           IGBagAsHshTable
                            (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

  IGBagAsHshTable <Element, ElementOps>&
           operator=        (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsHshTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsHshTable :
  public IGBagAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IGBagAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef  IBagAsHshTable <Element> Self;

#define IBagAsHshTableTypedef(Element)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsHshTable
                            (INumber = 100);


protected:

           IBagAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsHshTable :
  public IGBagAsHshTable
          <Element, ElementOps > {

  typedef  IVGBagAsHshTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsHshTableTypedef(Element, ElementOps)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsHshTableTypedef (Element, ElementOps);

public:

           IVGBagAsHshTable
                            (INumber = 100);


protected:

           IVGBagAsHshTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsHshTable :
  public IVGBagAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IVGBagAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef  IVBagAsHshTable <Element> Self;

#define IVBagAsHshTableTypedef(Element)\
  typedef  IVBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsHshTable
                            (INumber = 100);


protected:

           IVBagAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibaghsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
