/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGLST_H
#define _IBAGLST_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibaglst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsList;

template <class Element, class ElementOps>
class IGBagAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsListCursor
                            (IGBagAsList
                              <
                               Element, ElementOps> const&);

  IGBagAsListCursor <Element, ElementOps>&
           operator=        (IGBagAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsList :
  public IABag <Element> {
protected:

  typedef  IGBagAsList <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsListTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsListTypedef (Element, ElementOps);

public:

  typedef  IGBagAsListCursor
            <Element, ElementOps> Cursor;


           IGBagAsList
                            (INumber = 100);

           IGBagAsList
                            (IGBagAsList
                              <
                               Element, ElementOps> const&);

  IGBagAsList <Element, ElementOps>&
           operator=        (IGBagAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsList :
  public IGBagAsList
          <Element, ICOps <Element> > {

  typedef  IGBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBagAsList <Element> Self;

#define IBagAsListTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsList
                            (INumber = 100);


protected:

           IBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsList :
  public IGBagAsList
          <Element, ElementOps > {

  typedef  IVGBagAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsListTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsListTypedef (Element, ElementOps);

public:

           IVGBagAsList
                            (INumber = 100);


protected:

           IVGBagAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsList :
  public IVGBagAsList
          <Element, ICOps <Element> > {

  typedef  IVGBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBagAsList <Element> Self;

#define IVBagAsListTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsList
                            (INumber = 100);


protected:

           IVBagAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibaglst.inl>

#pragma info (restore)
#pragma pack ()

#endif
