/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBAGTAB_H
#define _IBAGTAB_H

#include <iabag.h>
#include <iicbag.h>
#include <iivbag.h>
#include <iibagtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGBagAsTable;

template <class Element, class ElementOps>
class IGBagAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGBagAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsTableCursor
                            (IGBagAsTable
                              <
                               Element, ElementOps> const&);

  IGBagAsTableCursor <Element, ElementOps>&
           operator=        (IGBagAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGBagAsTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsTable <Element, ElementOps> Self;

  typedef  IBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsTableTypedef(Element, ElementOps)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsTableTypedef (Element, ElementOps);

public:

  typedef  IGBagAsTableCursor
            <Element, ElementOps> Cursor;


           IGBagAsTable
                            (INumber = 100);

           IGBagAsTable
                            (IGBagAsTable
                              <
                               Element, ElementOps> const&);

  IGBagAsTable <Element, ElementOps>&
           operator=        (IGBagAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IBagAsTable :
  public IGBagAsTable
          <Element, ICOps <Element> > {

  typedef  IGBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IBagAsTable <Element> Self;

#define IBagAsTableTypedef(Element)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IBagAsTable
                            (INumber = 100);


protected:

           IBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGBagAsTable :
  public IGBagAsTable
          <Element, ElementOps > {

  typedef  IVGBagAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsTableTypedef(Element, ElementOps)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsTableTypedef (Element, ElementOps);

public:

           IVGBagAsTable
                            (INumber = 100);


protected:

           IVGBagAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVBagAsTable :
  public IVGBagAsTable
          <Element, ICOps <Element> > {

  typedef  IVGBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVBagAsTable <Element> Self;

#define IVBagAsTableTypedef(Element)\
  typedef  IVBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVBagAsTable
                            (INumber = 100);


protected:

           IVBagAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ibagtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
