/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGBagAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsTableCursor <Element, ElementOps>::
IGBagAsTableCursor
  (IGBagAsTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGBagAsTableCursor <Element, ElementOps>&
IGBagAsTableCursor <Element, ElementOps>::
operator=
  (IGBagAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsTableCursor <Element, ElementOps>::
IGBagAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGBagAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGBagAsTable <Element, ElementOps>::
IGBagAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGBagAsTable <Element, ElementOps>::
IGBagAsTable
  (IGBagAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGBagAsTable <Element, ElementOps>&
IGBagAsTable <Element, ElementOps>::
operator= (IGBagAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGBagAsTable <Element, ElementOps>::
IGBagAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGBagAsTable
 <Element, ElementOps>::Implementation&
IGBagAsTable <Element, ElementOps>::
ImplOf (IGBagAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IBagAsTable
// ---

// public members

template <class Element>
inline
IBagAsTable <Element>::
IBagAsTable (INumber numberOfElements)
: IGBagAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IBagAsTable <Element>::
IBagAsTable (PureImplementation& impl)
: IGBagAsTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGBagAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGBagAsTable <Element, ElementOps>::
IVGBagAsTable (INumber numberOfElements)
: IGBagAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGBagAsTable <Element, ElementOps>::
IVGBagAsTable (PureImplementation& impl)
: IGBagAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVBagAsTable
// ---

// public members

template <class Element>
inline
IVBagAsTable <Element>::
IVBagAsTable (INumber numberOfElements)
: IVGBagAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVBagAsTable <Element>::
IVBagAsTable (PureImplementation& impl)
: IVGBagAsTable
   <Element, ICOps <Element> > (impl)
{
}
