

#ifndef _IBASE_
#define _IBASE_
/*******************************************************************************
* FILE NAME: ibase.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBase                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iexcbase.hpp>

#pragma pack(4)

class ostream;



class IString;

class IBase {
public:

/*--------------------------- Boolean Definitions ----------------------------*/
typedef int
  Boolean;

enum BooleanConstants {
  false = 0,
  true  = 1
  };

/*--------------------------------- Messages ---------------------------------*/
static char
 *messageFile    ( );

static void
  setMessageFile ( const char *msgFileName );

static IMessageText
  messageText    ( unsigned long messageId,
                   const char*   textInsert1 = 0,
                   const char*   textInsert2 = 0,
                   const char*   textInsert3 = 0,
                   const char*   textInsert4 = 0,
                   const char*   textInsert5 = 0,
                   const char*   textInsert6 = 0,
                   const char*   textInsert7 = 0,
                   const char*   textInsert8 = 0,
                   const char*   textInsert9 = 0 );

/*------------------------------- Diagnostics --------------------------------*/
friend ostream
 &operator <<    ( ostream     &aStream,
                   const IBase &anObject );

IString
  asString       ( ) const,
  asDebugInfo    ( ) const;



struct Version   {
unsigned short
  major,
  minor;
  };


static Version
  version        ( );

protected:
/*---------------------------- Exception Severity ----------------------------*/
static const IException::Severity
  IC_IMPORTB unrecoverable,
  IC_IMPORTB recoverable;

private:
/*--------------------------------- Private ----------------------------------*/
static char
 *msgFile;



}; // IBase




/*-------------------------- Static Object Priority --------------------------*/
#define IBASE_PRIORITY -2147483647 - 1 + 1024

// with NLS (wide char) support
#define IC_NLS

// has restartable version
#define IC_HAS_RESTARTABLE






/*----------------------------- Functions Excluded from Documentation --------*/
#define IC_LIBRARYUSEONLY 1

/*----------------------------- Platform Macros ------------------------------*/
#if ( !defined(IC_PM) && !defined(IC_MOTIF) && !defined(IC_WIN) )
     #define IC_WIN
#endif

#if defined(IC_WIN)
  #define IC_PMWIN
  #define IC_MOTIFWIN
#endif

#if defined(IC_WIN_FLAGNOP)
  #define IC_PMWIN_FLAGNOP
  #define IC_MOTIFWIN_FLAGNOP
#endif

/*------------------------------ Version Levels ------------------------------*/
#ifdef IC_WIN
  #define IC_MAJOR_VERSION 320
#endif

#define IC_MINOR_VERSION 3

#define IC_OBSOLETE_1    310
#define IC_OBSOLETE_2    400

/*----------------------------- Obsolete Levels ------------------------------*/
#ifndef IC_OBSOLETE
 #ifdef IC_WIN
   #define IC_OBSOLETE  320
 #endif
#endif

extern "C" {

#ifdef IC_WIN

typedef void * (__stdcall
  IWinProc)( void *, unsigned long, void *, void * );

#endif

#ifndef IC_WIN

typedef void * _System
  IWinProc ( unsigned long, unsigned long, void *, void * );

#endif
}

#ifndef IC_RUNTIME
  #define IC_RUNTIME
#endif

#define IC_TRACE_RUNTIME

#ifdef IC_DEVELOP
  #define IC_TRACE_DEVELOP
#endif

#ifdef IC_TRACE_ALL
  #define IC_TRACE_DEVELOP
#endif

/***********************************************************/
/* The User's Guide documents the private message range as */
/* 0xF000 and above.  IC_UM_BASE still defined as 0xFF00   */
/* so as not to change the value of existing messages      */
/* for compatability with existing applications.           */
/***********************************************************/
/* CCL messages are in the range (0xF000) to (0xF0BF) */
#define IC_UM_BASE            ( 0xFF00 )
#ifdef IC_WIN
/*----------------Begin Drag and Drop Support---------------------------------*/
#define DM_RENDERPREPARE          ( IC_UM_BASE + 0xB0 )
#define DM_RENDERCOMPLETE         ( IC_UM_BASE + 0xB1 )
#define DM_RENDER                 ( IC_UM_BASE + 0xB2 )
#define DM_ENDCONVERSATION        ( IC_UM_BASE + 0xB3 )
#define DM_DISCARDOBJECT          ( IC_UM_BASE + 0xB4 )
#define DM_PRINTOBJECT            ( IC_UM_BASE + 0xB5 )
#define DM_DRAGOVER               ( IC_UM_BASE + 0xB6 )
#define DM_DROPHELP               ( IC_UM_BASE + 0xB7 )
#define DM_DRAGLEAVE              ( IC_UM_BASE + 0xB8 )
#define DM_DROP                   ( IC_UM_BASE + 0xB9 )
#define DM_REGISTER               ( IC_UM_BASE + 0xBA )
/*----------------End Drag and Drop Support-----------------------------------*/
#define WM_CHORD                  ( IC_UM_BASE + 0xC6 )
#define IC_UM_CONTEXT_HELP        ( IC_UM_BASE + 0xC7 )
#define IC_UM_LN_SELECT           ( IC_UM_BASE + 0xC8 )
#define IC_UM_QUERY_HELP_WINDOW   ( IC_UM_BASE + 0xC9 )
#define IC_UM_REQUEST_CANVASFONT  ( IC_UM_BASE + 0xCA )
#define IC_UM_LBUTTONDBLCLK       ( IC_UM_BASE + 0xCB )
#define HM_HELPSUBITEM_NOT_FOUND  ( IC_UM_BASE + 0xCC )
#define WM_MENUEND                ( IC_UM_BASE + 0xCD )
#define IC_UM_COMMAND             ( IC_UM_BASE + 0xCE )
#define IC_UM_SYSCOMMAND          ( IC_UM_BASE + 0xCF )
#define WM_CONTROL                ( IC_UM_BASE + 0xD0 )
#define WM_MATCHMNEMONIC          ( IC_UM_BASE + 0xD1 )
#define IC_UM_QUERYFRAMECTLCOUNT  ( IC_UM_BASE + 0xD2 )
#define IC_UM_FORMATFRAME         ( IC_UM_BASE + 0xD3 )
#define IC_UM_UPDATEFRAME         ( IC_UM_BASE + 0xD4 )
#define IC_UM_CALCFRAMERECT       ( IC_UM_BASE + 0xD5 )
#define WM_QUERYFOCUSCHAIN        ( IC_UM_BASE + 0xD6 )
#define IC_UM_32TO16              ( IC_UM_BASE + 0xD7 )
#define WM_BUTTON1CLICK           ( IC_UM_BASE + 0xD8 )
#define WM_BUTTON2CLICK           ( IC_UM_BASE + 0xD9 )
#define WM_BUTTON3CLICK           ( IC_UM_BASE + 0xDA )
#define WM_TRACKFRAME             ( IC_UM_BASE + 0xDB )
#define IC_SBM_SETPOS_WIN32S      ( IC_UM_BASE + 0xDC )
#define IC_UM_SLIDER_SCROLL       ( IC_UM_BASE + 0xDD )
#define WM_BEGINDRAG              ( IC_UM_BASE + 0xDE )
#define IC_UM_VSCROLL             ( IC_UM_BASE + 0xDF )
#define IC_UM_QUIT                ( IC_UM_BASE + 0xE0 )
#endif
#define IC_UM_DRAGDROP_RENDER     ( IC_UM_BASE + 0xE1 )
#define IC_UM_CANVAS_SETFOCUS     ( IC_UM_BASE + 0xE2 )
#define IC_UM_CANVAS_PAINT        ( IC_UM_BASE + 0xE3 )
#define IC_UM_CREATED             ( IC_UM_BASE + 0xE4 )
#define IC_UM_DESTROY_MENU        ( IC_UM_BASE + 0xE5 )
#define IC_UM_UNLATCH             ( IC_UM_BASE + 0xE6 )
#define IC_UM_BMP_VIEW            ( IC_UM_BASE + 0xE7 )
#define IC_UM_TXT_VIEW            ( IC_UM_BASE + 0xE8 )
#define IC_UM_BMP_TXT_VIEW        ( IC_UM_BASE + 0xE9 )
#define IC_UM_QRY_BMP_VISIBLE     ( IC_UM_BASE + 0xEA )
#define IC_UM_QRY_TXT_VISIBLE     ( IC_UM_BASE + 0xEB )
#define IC_UM_FLY_PAINT           ( IC_UM_BASE + 0xEC )
#define IC_UM_TOOLBAR             ( IC_UM_BASE + 0xED )
#define IC_UM_DRAW_DOWN           ( IC_UM_BASE + 0xEE )
#define IC_UM_QRY_PREVENTUPDATE   ( IC_UM_BASE + 0xEF )
#define IC_UM_WINDOWPOSCHANGED    ( IC_UM_BASE + 0xF0 )
#define IC_UM_DELAYNOTIFY         ( IC_UM_BASE + 0xF1 )
#define IC_UM_CLOSE               ( IC_UM_BASE + 0xF2 )
#define IC_UM_BIDI_CHANGE         ( IC_UM_BASE + 0xF3 )
#define IC_UM_DLG_APPLY_PRESSED   ( IC_UM_BASE + 0xF4 )
#define IC_UM_MEDIA_LOADED        ( IC_UM_BASE + 0xF5 )
#define IC_UM_MEDIA_UNLOADED      ( IC_UM_BASE + 0xF6 )
#define IC_UM_MM_MCI_CMDNOTIFY    ( IC_UM_BASE + 0xF7 )
#define IC_UM_CBN_ENTER           ( IC_UM_BASE + 0xF8 )
#define IC_UM_CBN_EFCHANGE        ( IC_UM_BASE + 0xF9 )
#define IC_UM_DESTROY_FRAME       ( IC_UM_BASE + 0xFA )
#define IC_UM_MM_MCI_POSITIONCHANGE ( IC_UM_BASE + 0xFB )
#define IC_UM_IS_AGGREGATE_CTRL   ( IC_UM_BASE + 0xFC )
#define IC_UM_TCM_SIZE            ( IC_UM_BASE + 0xFD )


#ifndef IC_ID_BASE
  #define IC_ID_BASE            ( 0x7000 )
#endif

#define IC_RESERVED_TIMERS         1000

/*-------------------------- Notification Delay Ids --------------------------*/
#define IC_NOTDEL_SETBT_SELECT    ( IC_ID_BASE + 0xF00 )
#define IC_NOTDEL_PUSHBT_SELECT   ( IC_ID_BASE + 0xF01 )
#define IC_NOTDEL_EF_DATAUPD      ( IC_ID_BASE + 0xF02 )
#define IC_NOTDEL_EF_LIMIT        ( IC_ID_BASE + 0xF03 )
#define IC_NOTDEL_MLE_DATAUPD     ( IC_ID_BASE + 0xF04 )
#define IC_NOTDEL_MLE_LIMIT       ( IC_ID_BASE + 0xF05 )
#define IC_NOTDEL_SCRL_POS        ( IC_ID_BASE + 0xF06 )
#define IC_NOTDEL_BOOK_COLOR      ( IC_ID_BASE + 0xF07 )
#define IC_NOTDEL_TITLE_COLOR     ( IC_ID_BASE + 0xF08 )
#define IC_NOTDEL_MENU_COLOR      ( IC_ID_BASE + 0xF09 )
#define IC_NOTDEL_CNR_TITLE       ( IC_ID_BASE + 0xF0A )
#define IC_NOTDEL_FRAME_ACTIVE    ( IC_ID_BASE + 0xF0B )
#define IC_NOTDEL_WINDOW_FONT     ( IC_ID_BASE + 0xF0C )
#define IC_NOTDEL_SHOW_WINDOW     ( IC_ID_BASE + 0xF0D )

/*------------------------------- Alias Names --------------------------------*/
#define IContainerObject           ICnrObj
#define IContainerControl          ICnrCtl
#define IDDEClientAcknowledgeEvent IDDECAckEvt
#define IDDEServerAcknowledgeEvent IDDESAckEvt
#define IDDEServerConversation     IDDESConv
#define IDDEServerHotLink          IDDESHotLnk
#define IDDEServerHotLinkItem      IDDESHLItem
#define IDDEActiveServer           IDDEActServ
#define IDDEClientHotLinkEvent     IDDECHLEvt
#define IDDEClosedConversation     IDDEClsConv
#define IRowColumnCanvas           IRCCv
#define AlignmentTag               Tag
#define RowColumn                  RCol

#pragma pack()

#ifndef _ISYNONYM_
  #include <isynonym.hpp>
#endif

#ifndef __MULTI__
 #error Error: Use of IBM Open Class Library requires the /Gm+ compiler option.
 #error Check the makefile (or its profile) for a missing /Gm+ option.
#endif

#endif /* _IBASE_ */


