/*******************************************************************************
* FILE NAME: ibasstrm.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Definition of the template functions declared in ibasstrm.hpp              *
*     IObjectToNumberElem                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
* ADDITONAL COPYRIGHTS:                                                        *
*  Copyright (C) 1996, Taligent, Inc. All rights reserved.                     *
*  Copyright (C) 1996, Lotus Development Corporation. All Rights Reserved.     *
*                                                                              *
*******************************************************************************/
#include <ibasstrm.hpp>

template <class AType>
IBaseStream& operator<<=(IACollection<AType>& c, IBaseStream& s)
{
    unsigned long num;
    num <<= s;
    while ( num-- != 0 ) {
        AType tmp;
        tmp <<= s;
        c.add(tmp);
    }
    return s;
}

template <class AType>
IBaseStream& operator>>=(const IACollection<AType>& c, IBaseStream& s)
{
    unsigned long num = c.numberOfElements();
    num >>= s;
    if ( num != 0 ) {
        ICursor& cursor = *c.newCursor();
        for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext()) {
            c.elementAt(cursor) >>= s;
        }
        delete &cursor;
    }
    return s;
}



template <class AType>
IBaseStream& operator<<=( IElemPointer<AType>& source, IBaseStream&  baseStream)
{
    ::resurrect((AType*&)source, baseStream );
    return  baseStream;
}

template <class AType>
IBaseStream& operator>>=(const IElemPointer<AType>&target, IBaseStream& baseStream)
{
    ::flatten((AType*)target, baseStream);         // This should probably use a const casting operator, but I don't see one in iptr.h.
    return baseStream;
}







