#ifndef _IBASSTRM_INL_
#define _IBASSTRM_INL_ 0
/*******************************************************************************
* FILE NAME: ibasstrm.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ibasstrm.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _IBASSTRM_
  #undef  _IBASSTRM_INL_
  #define _IBASSTRM_INL_ 1
  #include <ibasstrm.hpp>
#endif

#if _IBASSTRM_INL_
  #define inline
#endif


//===============================================================================
//
// Global operators for streaming support....
//

inline IBaseStream& operator<<=(char* c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(long& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(short& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(char& c, IBaseStream& s)
{
    return s.read((unsigned char&)c);
}

inline IBaseStream& operator<<=(signed char& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(unsigned long& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(unsigned short& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(unsigned char& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(float& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator<<=(double& c, IBaseStream& s)
{
    return s.read(c);
}

inline IBaseStream& operator>>=(const char* c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(long c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(short c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(char c, IBaseStream& s)
{
    return s.write((unsigned char)c);
}

inline IBaseStream& operator>>=(signed char c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(unsigned long c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(unsigned short c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(unsigned char c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(float c, IBaseStream& s)
{
    return s.write(c);
}

inline IBaseStream& operator>>=(double c, IBaseStream& s)
{
    return s.write(c);
}

#endif /* _IBASSTRM_INL_ */
