/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBCLLCT_H
#define _IBCLLCT_H

#include <imcllct.h>
#include <iglobals.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class ICursor {

  typedef  ICursorImpl Implementation;

public:

  virtual ~ICursor          ();

  void     copy             (ICursor const&);

  void     invalidate       ();

  IBoolean isValid          () const;

  IBoolean setToFirst       ();

  IBoolean setToNext        ();

  void     operator=        (ICursor const&);

  IBoolean operator==       (ICursor const&) const;

  IBoolean operator!=       (ICursor const&) const;

protected:

           ICursor          (Implementation*);

           ICursor          (ICursor const&);

  static
  inline
  Implementation&
           ImplOf           (ICursor const&);

private:

  Implementation*
           ivImpl;

  friend
  class    IACollectionBase;

  friend
  class    IVCollectionImpl;


};

#define forICursor(c) \
  for ((c).setToFirst (); (c).isValid (); (c).setToNext ())

// for backward compatibility
#define forCursor(c) \
  for ((c).setToFirst (); (c).isValid (); (c).setToNext ())

class IACollectionBase : protected IMetaCollection {
public:

protected:

           IACollectionBase ();

           IACollectionBase (IACollectionBase const&);

          ~IACollectionBase ();

  static
  ICursorImpl&
           CrsrImplOf       (ICursor& cursor);

  static
  ICursorImpl const&
           CrsrImplOf       (ICursor const& cursor);

  static
  ICursor* InterfaceFor     (ICursorImpl* cursor);
 

};

#pragma SOMAsDefault (pop)

#include <ibcllct.inl>

#pragma info (restore)
#pragma pack ()

#endif
