#ifndef _IBHANDLE_
#define _IBHANDLE_
/*******************************************************************************
* FILE NAME: ibhandle.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IHandle                                                                  *
*     ISemaphoreHandle                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ievtdata.hpp>

class ostream;
class IString;

#pragma pack(4)

class IHandle : public IBase {
typedef IBase
  Inherited;
public:
/*---------------------------------- Value -----------------------------------*/
typedef void*
  Value;

/*------------------------------- Constructors -------------------------------*/
  IHandle ( Value value );

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

friend ostream
 &operator << ( ostream&       aStream,
                const IHandle& aHandle );

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

protected:
/*---------------------------------- Value -----------------------------------*/
Value
  handle;
}; // IHandle


class ISemaphoreHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISemaphoreHandle ( Value hsem = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // ISemaphoreHandle

#pragma pack()

  #include <ibhandle.inl>

#endif // _IBHANDLE_
