#ifndef _IBHANDLE_INL_
#define _IBHANDLE_INL_ 0
/*******************************************************************************
* FILE NAME: ibhandle.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ibhandle.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IBHANDLE_
  #undef  _IBHANDLE_INL_
  #define _IBHANDLE_INL_ 1
  #include <ibhandle.hpp>
#endif

#if _IBHANDLE_INL_
  #define inline
#endif

inline IHandle :: IHandle ( Value value )
  : handle( value )
  {
  }

inline unsigned long IHandle :: asUnsigned ( ) const
  {
  return (unsigned long) this->handle;
  }

inline IHandle :: operator Value ( ) const
  {
  return this->handle;
  }

inline ISemaphoreHandle :: ISemaphoreHandle ( Value value )
  : IHandle( value )
  {
  }

#endif // _IBHANDLE_INL_
