#ifndef _IBIDISET_
#define _IBIDISET_
/*******************************************************************************
* FILE NAME: ibidiset.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBidiSettings                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ivbase.hpp>
#include <ihandle.hpp>

class IWindow;
class IGraphicContext;
class IBidiSettingsData;

#pragma pack(4)


class IBidiSettings : public IVBase {
typedef IVBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IBidiSettings ( const IWindow&         window );
  IBidiSettings ( const IWindowHandle    windowHandle );
  IBidiSettings ( const IGraphicContext& graphicContext );
  IBidiSettings ( const IPresSpaceHandle presSpace );

virtual
 ~IBidiSettings ( );

/*-------------------------- Bidirectional Support ---------------------------*/
static Boolean
  isBidiSupported ( );

virtual IBidiSettings
 &apply ( const IWindow&         window,
          Boolean                childInherit = true,
          Boolean                refresh      = true ),
 &apply ( const IWindowHandle    windowHandle,
          Boolean                childInherit = true,
          Boolean                refresh      = true ),
 &apply ( const IGraphicContext& graphicContext ),
 &apply ( const IPresSpaceHandle presSpace );

/*-------------------------------- Attributes --------------------------------*/
enum BidiTextType {
  visual,
  implicit
  };

enum BidiTextOrientation {
  textLeftToRight,
  textRightToLeft,
  textContextual
  };

enum BidiLayout {
  layoutLeftToRight,
  layoutRightToLeft
  };

enum BidiNumeralType {
  arabic,
  asStored,
  national,
  contextual
  };

enum BidiTextShape {
  displayShaped,
  saveShaped,
  nominalShape,
  initialShape,
  middleShape,
  finalShape,
  isolatedShape
  };

virtual IBidiSettings
 &setTextType                   ( BidiTextType        textType ),
 &setTextOrientation            ( BidiTextOrientation textOrientation ),
 &setWindowLayout               ( BidiLayout          windowLayout ),
 &setNumeralDisplay             ( BidiNumeralType     numeralDisplay ),
 &enableSymmetricSwapping       ( Boolean             enable = true ),
 &disableSymmetricSwapping      ( ),
 &enableWordByWordReordering    ( Boolean             enable = true ),
 &disableWordByWordReordering   ( ),
 &setTextShape                  ( BidiTextShape       textShape );

BidiTextType
  textType                      ( ) const;
BidiTextOrientation
  textOrientation               ( ) const;
BidiLayout
  windowLayout                  ( ) const;
BidiNumeralType
  numeralDisplay                ( ) const;
Boolean
  isSymmetricSwappingEnabled    ( ) const;
Boolean
  isWordByWordReorderingEnabled ( ) const;
BidiTextShape
  textShape                     ( ) const;

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IBidiSettings ( const IBidiSettings& settings );
IBidiSettings
 &operator=    ( const IBidiSettings& settings );

/*--------------------------------- Private ----------------------------------*/
IBidiSettingsData
 *fBidiSettingsData;
};


#pragma pack()

#endif /* _IBIDISET_ */
