#ifndef _IBITFLAG_
  #define _IBITFLAG_
/*******************************************************************************
* FILE NAME: ibitflag.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBitFlag                                                                 *
*                                                                              *
*   Definition of the macros:                                                  *
*     INESTEDBITFLAGCLASSDEF0                                                  *
*     INESTEDBITFLAGCLASSDEF1                                                  *
*     INESTEDBITFLAGCLASSDEF2                                                  *
*     INESTEDBITFLAGCLASSDEF3                                                  *
*     INESTEDBITFLAGCLASSDEF4                                                  *
*     INESTEDBITFLAGCLASSFUNCS                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#pragma pack(4)


class IBitFlag : public IBase {
typedef IBase
  Inherited;
public:
/*--------------------------------- Queries ----------------------------------*/
unsigned long
  asUnsignedLong         ( ) const,
  asExtendedUnsignedLong ( ) const;

/*-------------------------------- Comparisons -------------------------------*/
Boolean
  operator ==    ( const IBitFlag &rhs ) const,
  operator !=    ( const IBitFlag &rhs ) const;

protected:
/*------------------------- Constructors -------------------------------------*/
  IBitFlag       ( unsigned long value,
                   unsigned long extendedValue = 0 );

/*-------------------------------- Assignment --------------------------------*/
IBitFlag
 &setValue       ( unsigned long value ,
                   unsigned long extendedValue = 0 );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  ulClValue,
  ulClExtValue;
}; /* IBitFlag */


/*---------------------------- Macro Definitions -----------------------------*/
#define INESTEDBITFLAGCLASSDEF0( className, assoc )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC0( className )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC0( className )\
protected:\
  COMMONBITPROTECTED( className )\
}


#define INESTEDBITFLAGCLASSDEF1( className, assoc, base1 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF2( className, assoc, base1, base2 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF3( className, assoc, base1, base2, base3 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
    COMMONNEGBITPUBLICn( className, base3 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
  COMMONBITPUBLICn( className, base3 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF4( className, assoc, base1, base2, base3, base4 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
    COMMONNEGBITPUBLICn( className, base3 )\
    COMMONNEGBITPUBLICn( className, base4 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
  COMMONBITPUBLICn( className, base3 )\
  COMMONBITPUBLICn( className, base4 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSFUNCS( className, assoc )\
inline assoc##::##className  operator | ( const assoc##::##className &lhs,\
                                          const assoc##::##className &rhs )\
{\
  assoc##::##className aResult ( lhs.asUnsignedLong() | rhs.asUnsignedLong(),\
                                 lhs.asExtendedUnsignedLong() | rhs.asExtendedUnsignedLong() );\
  return aResult;\
}\
inline assoc##::##className\
  operator & ( const assoc##::##className &lhs,\
               const assoc##::##className##::Negated##className &rhs )\
{\
  assoc##::##className aResult ( lhs.asUnsignedLong() & rhs.asUnsignedLong(),\
                                 lhs.asExtendedUnsignedLong() & rhs.asExtendedUnsignedLong() );\
  return aResult;\
}\
inline assoc##::##className##::Negated##className\
  operator & ( const assoc##::##className##::Negated##className &lhs,\
               const assoc##::##className##::Negated##className &rhs )\
{\
  assoc##::##className##::Negated##className aResult ( lhs.asUnsignedLong() & rhs.asUnsignedLong(),\
                                                       lhs.asExtendedUnsignedLong() & rhs.asExtendedUnsignedLong() );\
  return aResult;\
}\
inline assoc##::##className\
  operator & ( const assoc##::##className##::Negated##className &lhs,\
               const assoc##::##className &rhs )\
{\
  return rhs & lhs;\
}\
inline unsigned long  operator & ( const assoc##::##className &lhs,\
                                   const assoc##::##className &rhs )\
{\
  unsigned long ulResult = lhs.asUnsignedLong() & rhs.asUnsignedLong();\
  return ( ulResult | (lhs.asExtendedUnsignedLong() & rhs.asExtendedUnsignedLong()) );\
} \
inline unsigned long  operator & ( const assoc##::##className &lhs,\
                                   const assoc##::##className &rhs )

#define COMMONBITPUBLIC( className )\
  className##&  operator |= ( const className &aFlag )\
  {\
    className tmpFlag = *this | aFlag;\
    this->setValue ( tmpFlag.asUnsignedLong(), tmpFlag.asExtendedUnsignedLong() );\
    return *this;\
  }\
  Negated##className  operator ~ ( ) const\
  {\
    Negated##className aResult ( ~asUnsignedLong(), ~asExtendedUnsignedLong() );\
    return aResult;\
  }\
  className##&  operator &= ( const Negated##className &aFlag )\
  {\
    className tmpFlag = *this & aFlag;\
    this->setValue ( tmpFlag.asUnsignedLong(), tmpFlag.asExtendedUnsignedLong() );\
    return *this;\
  }
#define COMMONBITPUBLIC0( className )\
  className  operator | ( const className &aFlag ) const\
  {\
    className aResult ( asUnsignedLong() | aFlag.asUnsignedLong(),\
                        asExtendedUnsignedLong() | aFlag.asExtendedUnsignedLong() );\
    return aResult;\
  }\
  className  operator & ( const Negated##className &aFlag ) const\
  {\
    className aResult ( asUnsignedLong() & aFlag.asUnsignedLong(),\
                        asExtendedUnsignedLong() & aFlag.asExtendedUnsignedLong() );\
    return aResult;\
  }\
  unsigned long  operator & ( const className &aFlag ) const\
  {\
    unsigned long ulResult = asUnsignedLong() & aFlag.asUnsignedLong();\
    return ( ulResult | (asExtendedUnsignedLong() & aFlag.asExtendedUnsignedLong()) );\
  }
#define COMMONBITPUBLIC1( className, baseName )\
  COMMONBITPUBLICn ( className, baseName )\
  friend inline className  operator | ( const className &lhs,\
                                        const className &rhs );\
  friend inline className  operator & ( const className &lhs,\
                                        const Negated##className &rhs );
#define COMMONBITPUBLICn( className, baseName )\
  className ( const baseName##::##className &aFlag )\
    : IBitFlag ( aFlag.asUnsignedLong(), aFlag.asExtendedUnsignedLong() ) {}
#define COMMONNEGBITPUBLIC0( className )\
    Negated##className  operator & ( const Negated##className &aFlag ) const\
    {\
      Negated##className aResult ( asUnsignedLong() & aFlag.asUnsignedLong(),\
                                   asExtendedUnsignedLong() & aFlag.asExtendedUnsignedLong() );\
      return aResult;\
    }
#define COMMONNEGBITPUBLIC1( className, baseName )\
    COMMONNEGBITPUBLICn( className, baseName )\
    friend inline Negated##className  operator & ( const Negated##className &lhs,\
                                                   const Negated##className &rhs );\
    friend inline className  operator & ( const Negated##className &lhs,\
                                          const className &rhs );
#define COMMONNEGBITPUBLICn( className, baseName )\
    Negated##className ( const baseName##::##className##::Negated##className &aFlag )\
      : IBitFlag ( aFlag.asUnsignedLong(), aFlag.asExtendedUnsignedLong() ) {}
#define COMMONBITPROTECTED( className )\
    className ( unsigned long val, unsigned long extVal=0 )\
      : IBitFlag ( val, extVal ) {}
#define COMMONNEGBITPROTECTED( className )\
    Negated##className ( unsigned long val, unsigned long extVal=0 )\
      : IBitFlag ( val, extVal ) {}

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <ibitflag.inl>

#endif /* _IBITFLAG_ */
