#ifndef _IBITFLAG_INL_
#define _IBITFLAG_INL_ 0
/*******************************************************************************
* FILE NAME: ibitflag.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ibitflag.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IBITFLAG_
  #undef  _IBITFLAG_INL_
  #define _IBITFLAG_INL_ 1
  #include <ibitflag.hpp>
#endif

#if _IBITFLAG_INL_
  #define inline
#endif

inline IBitFlag :: IBitFlag ( unsigned long value,
                              unsigned long extValue )
       : ulClValue( value ),
         ulClExtValue( extValue )
{}

inline unsigned long  IBitFlag :: asUnsignedLong ( ) const
{
  return( this->ulClValue );
}

inline unsigned long  IBitFlag :: asExtendedUnsignedLong ( ) const
{
  return( this->ulClExtValue );
}

inline IBitFlag  &IBitFlag :: setValue ( unsigned long value,
                                         unsigned long extValue )
{
  this->ulClValue = value;
  this->ulClExtValue = extValue;
  return( *this );
}

inline IBase::Boolean  IBitFlag :: operator == ( const IBitFlag &rhs ) const
{
  return( (this->asUnsignedLong() == rhs.asUnsignedLong())  &
          (this->asExtendedUnsignedLong() == rhs.asExtendedUnsignedLong()) );
}

inline IBase::Boolean  IBitFlag :: operator != ( const IBitFlag &rhs ) const
{
  return( (this->asUnsignedLong() != rhs.asUnsignedLong())  |
          (this->asExtendedUnsignedLong() != rhs.asExtendedUnsignedLong()) );
}

#endif /* _IBITFLAG_INL_ */
