#ifndef _IBMPCTL_
  #define _IBMPCTL_
/*******************************************************************************
* FILE NAME: ibmpctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBitmapControl                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istattxt.hpp>
#include <irect.hpp>
#include <ihandle.hpp>

class IResourceId;
class ISize;
class IBitmapControlData;

#pragma pack(4)

class IBitmapControl : public IStaticText {
typedef IStaticText
  Inherited;
public:
class Style;
/*------------------------ Constructors --------------------------------------*/
IBitmapControl ( unsigned long      id,
                 IWindow*           parent,
                 IWindow*           owner,
                 const IResourceId& bitmapId,
                 const IRectangle&  initial= IRectangle(),
                 const Style&       style = defaultStyle() );

IBitmapControl ( unsigned long     id,
                 IWindow*          parent,
                 IWindow*          owner,
                 unsigned long     bitmapId,
                 const IRectangle& initial= IRectangle(),
                 const Style&      style = defaultStyle() );

IBitmapControl ( unsigned long        id,
                 IWindow*             parent,
                 IWindow*             owner,
                 const IBitmapHandle& bitmapId = IBitmapHandle(),
                 const IRectangle&    initial= IRectangle(),
                 const Style&         style = defaultStyle() );

IBitmapControl ( unsigned long                   id,
                 IWindow*                        parent,
                 IWindow*                        owner,
                 ISystemBitmapHandle::Identifier bitmapId,
                 const IRectangle&               initial= IRectangle(),
                 const Style&                    style = defaultStyle() );

IBitmapControl ( unsigned long id,
                 IWindow*      parentDialog );

IBitmapControl ( const IWindowHandle& handle );

virtual
  ~IBitmapControl();

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IBitmapControl, IWindow, IControl, IStaticText);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeToBitmap;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*-------------------------------- Bitmaps -----------------------------------*/
virtual IBitmapControl
  &setBitmap ( unsigned long        bitmapId ),
  &setBitmap ( const IResourceId&   bitmapId ),
  &setBitmap ( const IBitmapHandle& handle );

virtual IBitmapControl
  &setBitmap ( ISystemBitmapHandle::Identifier bitmap );

IBitmapHandle
  bitmap    ( ) const;

/*----------------------------- Layout Support -------------------------------*/
virtual IBitmapControl
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*-------------------------------- Window Positioning ------------------------*/

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*--------------------------------- Private ----------------------------------*/
IBitmapControl
  &initialize(const Style& style);

static Style
  currentDefaultStyle;

IBitmapControlData
 *fBitmapControlData;

IBitmapHandle
  bmpHandle;
Boolean
  bSizeTo,
  returnback;

/*---------------------------- Hidden Members --------------------------------*/
  IBitmapControl(const IBitmapControl&);
IBitmapControl
  &operator=(const IBitmapControl);

};  // class IBitmapControl

INESTEDBITFLAGCLASSFUNCS(Style, IBitmapControl);
                                  // global style functions

#pragma pack()

#endif  /* _IBMPCTL_ */
