/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IBTREE_H
#define _IBTREE_H

#include <imtree.h>
#include <iglobals.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)


#pragma SOMAsDefault (off)

class ITreeCursor {

  typedef  ITreeCursorImpl Implementation;

public:

  virtual ~ITreeCursor      ();

  void     copy             (ITreeCursor const&);

  void     invalidate       ();

  IBoolean isValid          () const;

  IBoolean setToChild       (IPosition);

  IBoolean setToFirstExistingChild
                            ();

  IBoolean setToLastExistingChild
                            ();

  IBoolean setToNextExistingChild
                            ();

  IBoolean setToParent      ();

  IBoolean setToPreviousExistingChild
                            ();

  IBoolean setToRoot        ();

  void     operator=        (ITreeCursor const&);

  IBoolean operator==       (ITreeCursor const&) const;

  IBoolean operator!=       (ITreeCursor const&) const;

protected:

           ITreeCursor      (Implementation*);

           ITreeCursor      (ITreeCursor const&);

  static
  inline
  Implementation&
           ImplOf           (ITreeCursor const&);

private:

  Implementation*
           ivImpl;

  friend
  class    IATreeBase;


};

class IATreeBase : protected IMetaTree {
public:

protected:

           IATreeBase       ();

           IATreeBase       (IATreeBase const&);

          ~IATreeBase       ();

  static
  ITreeCursorImpl&
           CrsrImplOf       (ITreeCursor& cursor);

  static
  ITreeCursorImpl const&
           CrsrImplOf       (ITreeCursor const& cursor);

  static
  ITreeCursor*
           InterfaceFor     (ITreeCursorImpl* cursor);
 

};

#pragma SOMAsDefault (pop)

#include <ibtree.inl>

#pragma info (restore)
#pragma pack ()

#endif
