/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/
 
// -----------
// ITreeCursor
// -----------

// public members

inline void
ITreeCursor::
copy (ITreeCursor const& cursor)
{ ImplOf (*this).Copy (*cursor.ivImpl);
}

inline void
ITreeCursor::
invalidate ()
{ ImplOf (*this).Invalidate ();
}

inline IBoolean
ITreeCursor::
isValid () const
{ return ImplOf (*this).IsValid ();
}

inline IBoolean
ITreeCursor::
setToChild (IPosition position)
{ return ImplOf (*this).SetToChild (position);
}

inline IBoolean
ITreeCursor::
setToFirstExistingChild ()
{ return ImplOf (*this).SetToFirstExistingChild ();
}

inline IBoolean
ITreeCursor::
setToLastExistingChild ()
{ return ImplOf (*this).SetToLastExistingChild ();
}

inline IBoolean
ITreeCursor::
setToNextExistingChild ()
{ return ImplOf (*this).SetToNextExistingChild ();
}

inline IBoolean
ITreeCursor::
setToParent ()
{ return ImplOf (*this).SetToParent ();
}

inline IBoolean
ITreeCursor::
setToPreviousExistingChild ()
{ return ImplOf (*this).SetToPreviousExistingChild ();
}

inline IBoolean
ITreeCursor::
setToRoot ()
{ return ImplOf (*this).SetToRoot ();
}

inline void
ITreeCursor::
operator= (ITreeCursor const& cursor)
{ ImplOf (*this).Copy (ImplOf (cursor));
}

inline IBoolean
ITreeCursor::
operator== (ITreeCursor const& cursor) const
{ return ImplOf (*this).operator== (*cursor.ivImpl);
}

inline IBoolean
ITreeCursor::
operator!= (ITreeCursor const& cursor) const
{ return ImplOf (*this).operator!= (*cursor.ivImpl);
}

// protected members

inline
ITreeCursor::
ITreeCursor (Implementation* impl)
: ivImpl (impl)
{
}

inline
ITreeCursor::
ITreeCursor (ITreeCursor const& cursor)
: ivImpl (ImplOf (cursor).Clone ())                 
{
}

inline ITreeCursor::Implementation&
ITreeCursor::
ImplOf (ITreeCursor const& cursor)
{ return *(Implementation*)cursor.ivImpl;
}

// ----------
// IATreeBase
// ----------

// protected members

inline
IATreeBase::
IATreeBase ()
: IMetaTree ()
{
}

inline
IATreeBase::
IATreeBase (IATreeBase const& tree)
: IMetaTree (tree)
{
}

inline
IATreeBase::
~IATreeBase ()
{
}

inline ITreeCursorImpl&
IATreeBase::
CrsrImplOf (ITreeCursor& cursor)
{ return *cursor.ivImpl;
}

inline ITreeCursorImpl const&
IATreeBase::
CrsrImplOf (ITreeCursor const& cursor)
{ return *cursor.ivImpl;
}
