#ifndef _IBUFFER_INL_
#define _IBUFFER_INL_ 0
/*******************************************************************************
* FILE NAME: ibuffer.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ibuffer.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IBUFFER_
  #undef  _IBUFFER_INL_
  #define _IBUFFER_INL_ 1
  #include <ibuffer.hpp>
#endif

extern "C" {
  #include <limits.h>
}

#include <iexcbase.hpp>

#if _IBUFFER_INL_
  #define inline
#endif

#pragma info(nopar)

/*---------------------------- Overflow Checking -----------------------------*/
inline unsigned IBuffer :: checkAddition ( unsigned addend1, unsigned addend2 )
  {
  return ( addend1 < UINT_MAX - addend2 ) ? addend1 + addend2 : overflow();
  }
inline unsigned IBuffer :: checkMultiplication ( unsigned factor1,
                                                 unsigned factor2 )
  {
  return ( factor1 < UINT_MAX / factor2 ) ? factor1 * factor2 : overflow();
  }
/*---------------------------- Reference Counting ----------------------------*/
inline void IBuffer :: addRef ( )
  {
  refs++;
  }
inline void IBuffer :: removeRef ( )
  {
  #ifdef IC_DEVELOP
    IASSERT( refs != 0 );
  #endif
  if ( --refs == 0 )
    delete this;
  }
/*-------------------------------- Accessors ---------------------------------*/
inline unsigned IBuffer :: useCount ( ) const
  {
  return refs;
  }
inline unsigned IBuffer :: length ( ) const
  {
  return len;
  }
inline const char *IBuffer :: contents ( ) const
  {
  return data;
  }
inline char *IBuffer :: contents ( )
  {
  return data;
  }

#if 0     // moved these functions to ibuffer0.cpp for SOM


inline IBuffer *IBuffer :: fromContents ( const char *p )
  {
  return (IBuffer*)( p - offsetof( IBuffer, data ) );
  }


#endif // for SOM



#pragma info(restore)

#endif // _IBUFFER_INL_
