#ifndef _IBUFFERN_INL_
#define _IBUFFERN_INL_ 0
/*******************************************************************************
* FILE NAME: ibuffern.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline, non-memory-debug version  *
*   of operators new and delete for the classes declared in ibuffer.hpp.       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IBUFFER_
  #undef  _IBUFFERN_INL_
  #define _IBUFFERN_INL_ 1
  #include <ibuffer.hpp>
#endif

#if _IBUFFERN_INL_
  #define inline
#endif

#ifndef __DEBUG_ALLOC__
inline void* IBuffer::operator new ( size_t, unsigned realSize )
{
  void *p = ::new char[ checkAddition( sizeof( IBuffer ), realSize ) ];
  return p;
}

inline void IBuffer::operator delete ( void *p )
{
  ::delete [] (char*)p;
}
#endif

#endif // _IBUFFERN_INL_
