#ifndef _ICANVAS_INL_
#define _ICANVAS_INL_ 0
/*******************************************************************************
* FILE NAME: icanvas.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in icanvas.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICANVAS_
  #undef  _ICANVAS_INL_
  #define _ICANVAS_INL_ 1
  #include <icanvas.hpp>
#endif

#if _ICANVAS_INL_
  #define inline
#endif

/*-------------------------------- ICanvas -----------------------------------*/
inline ISize  ICanvas::layoutSize ( ) const
  {
  return sizClLayout;
  }
inline ICanvas  &ICanvas::setLayoutSize ( const ISize& size )
  {
  sizClLayout = size;
  return *this;
  }
inline IBase::Boolean  ICanvas::areChildrenReversed ( ) const
  {
  return bClChildrenReversed;
  }
#endif /* _ICANVAS_INL_ */
