#ifndef _ICLIPBRD_
#define _ICLIPBRD_
/*******************************************************************************
* FILE NAME: iclipbrd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IClipboard                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>

class IString;
class IClipboardData;
class IClipboardCursorData;

#pragma pack(4)


class IClipboard : public IVBase {
typedef IVBase
  Inherited;
public:
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IClipboard ( const IWindowHandle& clipboardWindow );
virtual
 ~IClipboard ( );

/*----------------------------- Clipboard Setup ------------------------------*/
virtual IClipboard
 &open                  ( ),
 &close                 ( ),
 &empty                 ( );

virtual Boolean
  isOpen                ( ) const;

/*------------------------- Clipboard Data Transfer --------------------------*/
virtual IClipboard
 &setText               ( const char*          text ),
 &setBitmap             ( const IBitmapHandle& bitmap ),
 &setData               ( const char*          format,
                          const void*          data,
                          unsigned long        dataLength ),
 &setHandle             ( const char*          format,
                          unsigned long        handle );
virtual Boolean
  hasText               ( ) const,
  hasBitmap             ( ) const,
  hasData               ( const char*          format ) const;

virtual IString
  text                  ( );
virtual IBitmapHandle
  bitmap                ( );
virtual void*
  data                  ( const char*          format );

/*---------------------------- Clipboard Formats -----------------------------*/
typedef unsigned long
  FormatHandle;

static IString
  primaryFormat         ( ),
  format                ( const Cursor&       cursor ),
  format                ( const FormatHandle& handle );

static FormatHandle
  registerFormat        ( const char*         privateFormat );

static FormatHandle
  formatAsHandle        ( const char*         format );

unsigned long
  formatCount           ( ) const;

/*----------------------- Clipboard Predefined Formats -----------------------*/

static const char
 IC_IMPORTU * const textFormat,
 IC_IMPORTU * const bitmapFormat,
 IC_IMPORTU * const metafileFormat,
 IC_IMPORTU * const displayTextFormat,
 IC_IMPORTU * const displayBitmapFormat,
 IC_IMPORTU * const displayMetafileFormat,
 IC_IMPORTU * const paletteFormat;

class Cursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( IClipboard&   clipboard );

virtual
 ~Cursor ( );

/*----------------------------- Cursor Movement ------------------------------*/
virtual Boolean
  setToFirst ( ),
  setToNext  ( );

/*---------------------------- Cursor Validation -----------------------------*/
virtual Boolean
  isValid    ( ) const;
virtual void
  invalidate ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  Cursor     ( const Cursor& cursor );
Cursor
 &operator=  ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
friend class IClipboard;

unsigned long
  formatHandle;
IClipboard
 &clipboard;

IClipboardCursorData
 *fCursorData;
};  // Cursor

/*--------------------------- Clipboard Ownership ----------------------------*/
IWindowHandle
  owner      ( ) const;

protected:
/*--------------------------- Clipboard Ownership ----------------------------*/

private:
/*------------------------------ Hidden Members ------------------------------*/
  IClipboard( const IClipboard& clipboard );
IClipboard
 &operator= ( const IClipboard& clipboard );

/*--------------------------------- Private ----------------------------------*/
IClipboard
 &autoOpen ( );

  IClipboard ( );

IClipboardData
 *fClipboardData;
};  // IClipBoard


#pragma pack()

#endif /* _ICLIPBRD_ */
