/*******************************************************************************
* FILE NAME: icmdhdr.c                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the template functions                *
*   declared in icmdhdr.hpp.                                                   * 
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icmdhdr.hpp>

template<class ATarget>
ICommandConnectionTo<ATarget>::ICommandConnectionTo( ATarget& target,
                                                     MemberFunction memberFunction )
: fTarget(target), fConnectedMember( memberFunction )
{
}

template<class ATarget>
ICommandConnectionTo<ATarget>::~ICommandConnectionTo()
{
}

template<class ATarget>
Boolean
ICommandConnectionTo<ATarget>::command( ICommandEvent& event )
{
    return ( fTarget.*fConnectedMember ) ( event );
}
    
template<class ATarget>
Boolean
ICommandConnectionTo<ATarget>::systemCommand( ICommandEvent& event )
{
    return ( fTarget.*fConnectedMember ) ( event );
}

