#ifndef _ICMDHDR_
#define _ICMDHDR_
/*******************************************************************************
* FILE NAME: icmdhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ICommandHandler                                                          *
*     ICommandConnectionTo                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icmdevt.hpp>

class IEvent;

#pragma pack(4)

class ICommandHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICommandHandler ( );
virtual
 ~ICommandHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  command       ( ICommandEvent& event ),
  systemCommand ( ICommandEvent& event );
}; // ICommandHandler

#pragma info(nocpy)

template <class ATarget>
class ICommandConnectionTo : public ICommandHandler {
typedef ICommandHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef Boolean  (ATarget::* MemberFunction)( ICommandEvent& );

/*------------------------------- Constructors -------------------------------*/
  ICommandConnectionTo ( ATarget&       target,
                         MemberFunction memberFunction );
virtual
 ~ICommandConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  command       ( ICommandEvent& event ),
  systemCommand ( ICommandEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
MemberFunction
  fConnectedMember;
}; // ICommandConnectionTo

#ifndef __TEMPINC__
  #include <icmdhdr.c>
#endif

#pragma info(restore)

#pragma pack()

#endif /* _ICMDHDR_ */
