#ifndef _ICNRCTL_INL_
#define _ICNRCTL_INL_ 0
/*******************************************************************************
* FILE NAME: icnrctl.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in icnrctl.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICNRCTL_
  #undef  _ICNRCTL_INL_
  #define _ICNRCTL_INL_ 1
  #include <icnrctl.hpp>
#endif

#if _ICNRCTL_INL_
  #define inline
#endif

inline IBase::Boolean IContainerControl::operator==( const IContainerControl& that)
       { return (&that==this); }

inline IBase::Boolean IContainerControl::willDeleteObjectsOnClose( ) const
       { return ((flClState & IContainerControl::autoDeleteObjects) ? true : false);}

inline IBase::Boolean IContainerControl::willDeleteColumnsOnClose( ) const
       { return ((flClState & IContainerControl::autoDeleteColumns) ? true : false);}

inline unsigned long IContainerControl::numberOfObjectChanges() const
       {return ulClObjectChanges; }

inline unsigned long IContainerControl::numberOfColumnChanges() const
       {return ulClColumnChanges; }

inline IBase::Boolean IContainerControl::isRefreshOn() const
{ return ((flClState & IContainerControl::noRefresh) ? false : true); }

inline IContainerControl& IContainerControl :: disableCaching()
{
   enableCaching(0);
   return *this;
}

#endif // _ICNRCTL_INL_
