#ifndef _ICNRDIEV_
#define _ICNRDIEV_
/*******************************************************************************
* FILE NAME: icnrdiev.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrDrawItemEvent                                                        *
*     ICnrDrawBackgroundEvent                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <idievt.hpp>

class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma pack(4)

class ICnrDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrDrawItemEvent    ( const IEvent& event);

virtual
 ~ICnrDrawItemEvent    ( );

/*----------------------- Related Members ------------------------------------*/
enum ItemType  {
  text,
  icon,
  treeIcon,
  detailsView,
  title
  };

/*-------------------------- Event Information -------------------------------*/
virtual IContainerObject
 *object               ( ) const;
virtual IContainerControl
 *container            ( ) const;
virtual IContainerColumn
 *column               ( ) const;
virtual ItemType
  itemType             ( ) const;

virtual IPresSpaceHandle
  itemPresSpaceHandle  ( ) const;

virtual IRectangle
  itemRect             ( ) const;

};

class ICnrDrawBackgroundEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------ Constructors --------------------------------------*/
  ICnrDrawBackgroundEvent  ( const IEvent& event);

virtual
 ~ICnrDrawBackgroundEvent  ( );

/*-------------------------- Event Information -------------------------------*/
virtual IContainerControl
 *container            ( ) const;

virtual IPresSpaceHandle
  itemPresSpaceHandle  ( ) const;

virtual unsigned long
  itemId               ( ) const;

virtual IRectangle
  itemRect             ( ) const;

};

#pragma pack()

#endif // _ICNRDIEV_
