#ifndef _ICNRDIHD_
#define _ICNRDIHD_
/*******************************************************************************
* FILE NAME: icnrdihd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrDrawHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icnrdiev.hpp>

class IControl;
class IContainerControl;

#pragma pack(4)

class ICnrDrawHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
virtual
 ~ICnrDrawHandler   ( );

/*------------------------ Event Processing ----------------------------------*/
virtual Boolean
  drawText          ( ICnrDrawItemEvent&       event),
  drawIcon          ( ICnrDrawItemEvent&       event),
  drawTreeIcon      ( ICnrDrawItemEvent&       event),
  drawDetailsItem   ( ICnrDrawItemEvent&       event),
  drawTitle         ( ICnrDrawItemEvent&       event),
  drawBackground    ( ICnrDrawBackgroundEvent& event);


/*---------------------------- Event Dispatching -----------------------------*/
virtual ICnrDrawHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );


protected:
/*------------------------- Constructors -------------------------------------*/
  ICnrDrawHandler   ( );

/*-------------------------- Event Dispatching -------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event);

private:
/*------------------------- Hidden Members -----------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

};

#pragma pack()

#endif
