#ifndef _ICNREEVT_
 #define _ICNREEVT_
/*******************************************************************************
* FILE NAME: icnreevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEditEvent                                                            *
*     ICnrBeginEditEvent                                                       *
*     ICnrEndEditEvent                                                         *
*     ICnrReallocStringEvent                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrevt.hpp>
#include <istring.hpp>

class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma pack(4)

class ICnrEditEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEditEvent  ( const IControlEvent& event);

virtual
 ~ICnrEditEvent  ( );

/*----------------------------- Event Information ----------------------------*/
Boolean
  isTitleWindow() const;
Boolean
  isLeftDetailsHeading() const;
Boolean
  isRightDetailsHeading() const;
Boolean
  isDetailsData() const,
  isLeftDetails() const;
Boolean
  isRightDetails() const;

virtual IContainerObject
 *object()  const;

virtual IContainerColumn
 *column()  const;

virtual IContainerControl
 *container()  const;

protected:
/*--------------------------------- Text -------------------------------------*/
char
 **textRef()  const;

unsigned long
 textSize()   const;

};

class ICnrReallocStringEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrReallocStringEvent ( const IControlEvent& event);

virtual
 ~ICnrReallocStringEvent ( );

/*----------------------------- Event Information ----------------------------*/
virtual IString
  currentText()  const,
  newText()      const;

long
  newTextSize()  const;

/*------------------------------ Text Allocation -----------------------------*/
void
  reallocateString();
void
  reallocateText();
};


class ICnrBeginEditEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrBeginEditEvent ( const IControlEvent& event);

virtual
 ~ICnrBeginEditEvent ( );

/*----------------------------- Event Information ----------------------------*/
IString
  currentText();
};


class ICnrEndEditEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEndEditEvent ( const IControlEvent& evt);

virtual
 ~ICnrEndEditEvent ( );

/*----------------------------- Event Information ----------------------------*/
IString
  newText(),
  currentText();

private:
/*-------------------------------- Private -----------------------------------*/
friend class ICnrEditHandler;
IString
  strNewText;
};

#pragma pack()

#endif
