#ifndef _ICNREVT_
#define _ICNREVT_
/*******************************************************************************
* FILE NAME: icnrevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEvent                                                                *
*     ICnrEnterEvent                                                           *
*     ICnrEmphasisEvent                                                        *
*     ICnrHelpEvent                                                            *
*     ICnrQueryDeltaEvent                                                      *
*     ICnrScrollEvent                                                          *
*     ICnrPaintBackground                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ictlevt.hpp>
#include <icnrobj.hpp>

class ICnrEnterEvent;
class ICnrEvent;
class ICnrHelpEvent;
class ICnrQueryDeltaEvent;
class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma pack(4)

class ICnrEvent : public IControlEvent {
typedef IControlEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEvent      ( const IControlEvent& event);

virtual
 ~ICnrEvent      ( );

   protected:
/*--------------------------- Event Information ------------------------------*/
unsigned long
  containerId    ( ) const;

};


class ICnrEnterEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEnterEvent  ( const IControlEvent& event);

virtual
 ~ICnrEnterEvent ();

/*----------------------------- Event Information ----------------------------*/
IContainerObject
 *object          ( ) const;

Boolean
  enterPressed    ( ) const,
  validObject     ( ) const;
};


class ICnrEmphasisEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEmphasisEvent  ( const IControlEvent& event);

virtual
 ~ICnrEmphasisEvent  ( );

/*----------------------------- Event Information ----------------------------*/
Boolean
  changed          ( IContainerObject::Emphasis  emphasis) const;

IContainerObject
 *object           ( )  const;

};


class ICnrQueryDeltaEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrQueryDeltaEvent ( const IControlEvent& event);

virtual
 ~ICnrQueryDeltaEvent ( );

/*------------------------------ Event Information ---------------------------*/
Boolean
  atTopDelta       ( ) const,
  atBottomDelta    ( ) const,
  atFirstObject    ( ) const,
  atLastObject     ( ) const;
};


class ICnrScrollEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrScrollEvent ( const IControlEvent& event );

virtual
 ~ICnrScrollEvent ( );

/*------------------------------- Event Information --------------------------*/
long
  amount            ( ) const;
Boolean
  isLeftDetails     ( ) const,
  isRightDetails    ( ) const,
  isHorizontal      ( ) const,
  isVertical        ( ) const;
};


class ICnrHelpEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrHelpEvent ( const IControlEvent& event );

virtual
 ~ICnrHelpEvent ( );

/*------------------------------- Event Information --------------------------*/
IContainerObject
 *object       ( ) const;
IContainerColumn
 *column       ( ) const;

};

#pragma pack()

#endif /* _ICNREVT_ */
