#ifndef _ICNRHDR_
#define _ICNRHDR_
/*******************************************************************************
* FILE NAME: icnrhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrHandler                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icnrevt.hpp>

class ICnrHdrPrivateData;

#pragma pack(4)

class ICnrHandler : public IHandler {
typedef IHandler
   Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
ICnrHandler();

virtual
 ~ICnrHandler();

/*---------------------------- Event Processing ----------------------------------*/
virtual Boolean
  deltaReached(ICnrQueryDeltaEvent& event);

virtual Boolean
  treeCollapsed    (IContainerObject* collapsedObject,
                    IContainerControl* container),

  treeExpanded     (IContainerObject* expandedObject,
                    IContainerControl* container),

  enter            (ICnrEnterEvent& event),
  selectedChanged  (ICnrEmphasisEvent& event);

virtual Boolean
  inuseChanged(ICnrEmphasisEvent& event),
  cursoredChanged(ICnrEmphasisEvent& event),
  windowScrolled(ICnrScrollEvent& event);

virtual Boolean
  help(ICnrHelpEvent& event);

/*--------------------------- Event Dispatching ------------------------------*/
virtual ICnrHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );

protected:
/*--------------------------- Event Dispatching ------------------------------*/
virtual Boolean
  dispatchHandlerEvent(IEvent& event);

private:
/*----------------------------- Private --------------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );


};

#pragma pack()

#endif
