#ifndef _ICNRMHDR_
#define _ICNRMHDR_
/*******************************************************************************
* FILE NAME: icnrmhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrMenuHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imenuhdr.hpp>
#include <ievent.hpp>

class IContainerObject;
class IContainerControl;

#pragma pack(4)


class ICnrMenuHandler : public IMenuHandler {
typedef IMenuHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
virtual
 ~ICnrMenuHandler      ( );


/*---------------------------- Event Information -----------------------------*/
IContainerObject
 *popupMenuObject     ( );

/*--------------------------- Event Dispatching ------------------------------*/
virtual ICnrMenuHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );

protected:
/*---------------------------- Constructors ----------------------------------*/
  ICnrMenuHandler      ( );


/*--------------------------- Event Dispatching ------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event);

virtual void
  addSourceEmphasis( const IMenuEvent& menuEvent ),
  removeSourceEmphasis( const IMenuEvent& menuEvent );

virtual Boolean
  menuEnded     ( IMenuEvent& menuEvent );

private:
/*-------------------------------- Private -----------------------------------*/
/*----------------------------- Hidden Members -------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

IContainerObject
 *pcnrobjClMenu;
};

#pragma pack()

#endif
