#ifndef _ICOLOBSV_
  #define _ICOLOBSV_
/*******************************************************************************
* FILE NAME: icolobsv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionObserver                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <iobservr.hpp>
#include <iseq.h>
#include <ivseq.h>

#pragma implementation("icolobsv.c")

template <class Element> class IPartOrderedCollection;
template <class Element, class ViewClass, class Collection> class ICollectionViewData;
class   ICollectionObserverData;

#pragma pack(4)

template <class Element, class ViewClass, class Collection>
  class ICollectionObserver : public IObserver {

typedef IObserver
  Inherited;

public:

/*------------------------- Constructors -------------------------------------*/
virtual
 ~ICollectionObserver ( );

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionObserver ( );

  ICollectionObserver ( const ICollectionObserver<Element,ViewClass,Collection>& source );
ICollectionObserver<Element,ViewClass,Collection>
 &operator=           ( const ICollectionObserver<Element,ViewClass,Collection>& source );


/*------------------------- View and Collection ------------------------------*/
virtual ViewClass
 *viewer        (  ) const;

virtual ICollectionObserver<Element,ViewClass,Collection>
 &setViewer     ( ViewClass*  viewer );

virtual IPartOrderedCollection<Element>
 *collection    (  ) const;

virtual ICollectionObserver<Element,ViewClass,Collection>
 &setCollection ( IPartOrderedCollection<Element>* collection );


/*------------------------- Notification Members -----------------------------*/
virtual IObserver
 &dispatchNotificationEvent ( const INotificationEvent& event );

class ElementObserver : public IObserver {

typedef IObserver
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  ElementObserver ( ViewClass*     viewer,
                    Element        element,
                    unsigned long  position );
  ElementObserver ( const ElementObserver&  source );

virtual
 ~ElementObserver ( );

/*------------------------- Operators ----------------------------------------*/
virtual ElementObserver
 &operator=       ( const ElementObserver & source );


/*------------------------- Element ------------------------------------------*/
virtual Element
  element      ( ) const;
virtual ElementObserver
 &setElement   ( const Element  element );
virtual unsigned long
  position     ( ) const;
virtual ElementObserver
 &setPosition  ( unsigned long  position );


protected:

/*------------------------- Notification Members -----------------------------*/
virtual IObserver
 &dispatchNotificationEvent ( const INotificationEvent& event );

private:

ViewClass
 *fInterestedParty;
Element
  fElement;
unsigned long
  fPosition;


};  // end of ElementObserver


ViewClass
 *fReportTo;
IPartOrderedCollection<Element>
 *fCollection;
ISequence<ElementObserver *>
  fElementObservers;
ISequence<ElementObserver *>::Cursor
  fCursor;
ICollectionObserverData
 *fCollectionObserverData;

void
  deleteAllElementObservers ( );

friend ICollectionViewData<Element, ViewClass, Collection>;
friend ViewClass;

}; // ICollectionObserver

#if ! defined (__TEMPINC__)
#include <icolobsv.c>
#endif

#pragma pack()

#endif  /*  _ICOLOBSV_  */
