#ifndef _ICOLOR_
#define _ICOLOR_
/*******************************************************************************
* FILE NAME: icolor.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IColor                                                                   *
*     IDeviceColor                                                             *
*     IGUIColor                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>

class IColorData;
class IDeviceColorData;
class IGUIColorData;

#pragma pack(4)

class IColor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
enum Color {
  white,
  blue,
  red,
  pink,
  green,
  cyan,
  yellow,
  black,
  darkGray,
  darkBlue,
  darkRed,
  darkPink,
  darkGreen,
  darkCyan,
  brown,
  paleGray
  };

enum SystemColor {
  shadowIconHiliteBgnd, shadowIconHiliteFgnd, shadowIconText,
  entryFieldBgnd, listBoxBgnd,
  disableMenuText, menuHiliteText, menuHiliteBgnd,
  notebookPageBgnd,
  inactiveScrollBar,
  defaultControl,
  buttonLight, buttonMiddle, buttonDark, defaultButton,
  titleLine,
  menuShadow, dialogShadow,
  iconText,
  dialogBgnd,
  hiliteFgnd, hiliteBgnd,
  inactiveTitleTextBgnd, activeTitleTextBgnd,
  inactiveTitleText, activeTitleText,
  outputText, windowStaticText,
  scrollBar,
  desktopBgnd,
  activeTitleBgnd, inactiveTitleBgnd,
  menuBgnd, windowBgnd,
  frameBorder,
  menuText, windowText, titleText,
  sizeBar, scrollArrow,
  activeFrameBorder, inactiveFrameBorder,
  mainWindowBgnd, helpWindowBgnd,
  helpText, helpHiliteText
  };


  IColor    ( Color         color );
  IColor    ( unsigned char red,
              unsigned char green,
              unsigned char blue );
  IColor    ( const IColor& color );
  IColor    ( long          index );
  IColor    ( SystemColor value );

IColor&
  operator= ( const IColor& color );

virtual
 ~IColor    ( );

/*-------------------------------- Color Mix ---------------------------------*/
unsigned char
  redMix    ( ) const,
  greenMix  ( ) const,
  blueMix   ( ) const;

IColor
 &setRed   ( unsigned char redMix ),
 &setGreen ( unsigned char greenMix ),
 &setBlue  ( unsigned char blueMix );

virtual long
  index       ( ) const;
Color
  value       ( ) const;
SystemColor
  systemColor ( ) const;

/*------------------------------- Comparisons --------------------------------*/
Boolean
  operator!= ( const IColor& color ) const,
  operator== ( const IColor& color ) const;

/*------------------------------- Conversions --------------------------------*/
long
  asRGBLong ( ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  IColor ( );

private:
/*--------------------------------- Private ----------------------------------*/
Boolean
  checkSysRGBValue();

unsigned char
  ucClRed,
  ucClGreen,
  ucClBlue;

long
  cClColor;
unsigned long
  bClColor;

IColorData
 *fColorData;
}; // IColor


class IDeviceColor : public IColor {
typedef IColor
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
enum DeviceColor {
  defaultColor,
  background,
  neutral
  };

  IDeviceColor ( DeviceColor color );
virtual
 ~IDeviceColor ( );

/*--------------------------- Color Representation ---------------------------*/
DeviceColor
  deviceColor ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
DeviceColor
  dcClDeviceColor;

IDeviceColorData
 *fDeviceColorData;
}; // IDeviceColor


class IGUIColor : public IColor {
typedef IColor
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGUIColor ( SystemColor value );
virtual
 ~IGUIColor ( );

/*--------------------------- Color Representation ---------------------------*/
SystemColor
  systemColor ( ) const;

/*-------------------------- Setting System Colors ---------------------------*/
IGUIColor
 &setColor ( const IColor& newColor );

private:
/*--------------------------------- Private ----------------------------------*/
SystemColor
  scClSysColor;

IGUIColorData
 *fGUIColorData;

/*----------------------------- Obsolete Members -----------------------------*/
#if (IC_OBSOLETE > IC_OBSOLETE_1) && (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
typedef SystemColor
  SysColor;
#endif
}; // IGUIColor

#pragma pack()

  #include <icolor.inl>

#endif /* _ICOLOR_ */
